"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensAttributes = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _config_builder = require("@kbn/lens-embeddable-utils/config_builder");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLensAttributes = params => {
  const {
    services: {
      lens,
      dataViews
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    navigateToPrefilledEditor
  } = lens;
  const {
    value: attributes,
    error
  } = (0, _useAsync.default)(async () => {
    const {
      formula: formulaAPI
    } = await lens.stateHelperApi();
    if (!dataViews || !formulaAPI || !params.dataset) {
      return undefined;
    }
    const builder = new _config_builder.LensConfigBuilder(dataViews, formulaAPI);
    return builder.build(params);
  }, [params.chartType, params.dataset, dataViews]);
  const injectFilters = (0, _react.useCallback)(({
    filters,
    query
  }) => {
    if (!attributes) {
      return null;
    }
    return {
      ...attributes,
      state: {
        ...attributes.state,
        query,
        filters: [...attributes.state.filters, ...filters]
      }
    };
  }, [attributes]);
  const openInLensAction = (0, _react.useCallback)(({
    timeRange,
    query,
    filters,
    searchSessionId
  }) => () => {
    const injectedAttributes = injectFilters({
      filters,
      query
    });
    if (injectedAttributes) {
      navigateToPrefilledEditor({
        id: '',
        timeRange,
        attributes: injectedAttributes,
        searchSessionId
      }, {
        openInNewTab: true
      });
    }
  }, [injectFilters, navigateToPrefilledEditor]);
  const getExtraActions = (0, _react.useCallback)(({
    timeRange,
    filters = [],
    query = {
      language: 'kuery',
      query: ''
    },
    searchSessionId
  }) => {
    const openInLens = getOpenInLensAction(openInLensAction({
      timeRange,
      filters,
      query,
      searchSessionId
    }));
    return [openInLens];
  }, [openInLensAction]);
  const getFormula = () => {
    if (params.chartType === 'xy') {
      return params.layers[0].yAxis[0].value;
    }
    return params.value;
  };
  return {
    formula: getFormula(),
    attributes: attributes,
    getExtraActions,
    error
  };
};
exports.useLensAttributes = useLensAttributes;
const getOpenInLensAction = onExecute => {
  return {
    id: 'openInLens',
    getDisplayName(_context) {
      return _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.actions.openInLines', {
        defaultMessage: 'Open in Lens'
      });
    },
    getIconType(_context) {
      return 'visArea';
    },
    type: 'actionButton',
    async isCompatible(_context) {
      return true;
    },
    async execute(_context) {
      onExecute();
    },
    order: 100
  };
};