"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataView = exports.generateDataViewId = exports.TIMESTAMP_FIELD = exports.DATA_VIEW_PREFIX = void 0;
var _uuid = require("uuid");
var _useAsyncRetry = _interopRequireDefault(require("react-use/lib/useAsyncRetry"));
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TIMESTAMP_FIELD = exports.TIMESTAMP_FIELD = '@timestamp';
const DATA_VIEW_PREFIX = exports.DATA_VIEW_PREFIX = 'infra_metrics';
const generateDataViewId = index => {
  // generates a unique but the same uuid as long as the index pattern doesn't change
  return `${DATA_VIEW_PREFIX}_${(0, _uuid.v5)(index, _uuid.v5.DNS)}`;
};
exports.generateDataViewId = generateDataViewId;
const useDataView = ({
  index
}) => {
  const {
    services: {
      dataViews
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const state = (0, _useAsyncRetry.default)(async () => {
    if (!index) {
      return Promise.resolve(undefined);
    }
    return dataViews.get(index, false).catch(() =>
    // if data view doesn't exist, create an ad-hoc one
    dataViews.create({
      id: generateDataViewId(index),
      title: index,
      timeFieldName: TIMESTAMP_FIELD
    }));
  }, [index]);
  const {
    value: dataView,
    loading,
    error,
    retry
  } = state;
  return {
    index,
    dataView,
    loading,
    retry,
    error
  };
};
exports.useDataView = useDataView;