"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithKueryAutocompletion = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class WithKueryAutocompletionComponent extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      currentRequest: null,
      suggestions: []
    });
    (0, _defineProperty2.default)(this, "loadSuggestions", async (expression, cursorPosition, maxSuggestions, transformSuggestions) => {
      const {
        indexPattern
      } = this.props;
      const language = 'kuery';
      const hasQuerySuggestions = this.props.kibana.services.unifiedSearch.autocomplete.hasQuerySuggestions(language);
      if (!hasQuerySuggestions) {
        return;
      }
      this.setState({
        currentRequest: {
          expression,
          cursorPosition
        },
        suggestions: []
      });
      const suggestions = (await this.props.kibana.services.unifiedSearch.autocomplete.getQuerySuggestions({
        language,
        query: expression,
        selectionStart: cursorPosition,
        selectionEnd: cursorPosition,
        indexPatterns: [indexPattern],
        boolFilter: []
      })) || [];
      const transformedSuggestions = transformSuggestions ? transformSuggestions(suggestions) : suggestions;
      this.setState(state => state.currentRequest && state.currentRequest.expression !== expression && state.currentRequest.cursorPosition !== cursorPosition ? state // ignore this result, since a newer request is in flight
      : {
        ...state,
        currentRequest: null,
        suggestions: maxSuggestions ? transformedSuggestions.slice(0, maxSuggestions) : transformedSuggestions
      });
    });
  }
  render() {
    const {
      currentRequest,
      suggestions
    } = this.state;
    return this.props.children({
      isLoadingSuggestions: currentRequest !== null,
      loadSuggestions: this.loadSuggestions,
      suggestions
    });
  }
}
const WithKueryAutocompletion = exports.WithKueryAutocompletion = (0, _public.withKibana)(WithKueryAutocompletionComponent);