"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callSetupMlModuleAPI = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _log_analysis = require("../../../../../common/log_analysis");
var _runtime_types = require("../../../../../common/runtime_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const callSetupMlModuleAPI = async (requestArgs, fetch) => {
  const {
    moduleId,
    start,
    end,
    spaceId,
    sourceId,
    indexPattern,
    jobOverrides = [],
    datafeedOverrides = [],
    query,
    useDedicatedIndex = false
  } = requestArgs;
  const response = await fetch(`/internal/ml/modules/setup/${moduleId}`, {
    method: 'POST',
    version: '1',
    body: JSON.stringify(setupMlModuleRequestPayloadRT.encode({
      start,
      end,
      indexPatternName: indexPattern,
      prefix: (0, _log_analysis.getJobIdPrefix)(spaceId, sourceId, 'hashed'),
      startDatafeed: true,
      jobOverrides,
      datafeedOverrides,
      query,
      useDedicatedIndex
    }))
  });
  return (0, _runtime_types.decodeOrThrow)(setupMlModuleResponsePayloadRT)(response);
};
exports.callSetupMlModuleAPI = callSetupMlModuleAPI;
const setupMlModuleTimeParamsRT = rt.partial({
  start: rt.number,
  end: rt.number
});
const setupMlModuleJobOverridesRT = rt.type({
  job_id: rt.string,
  custom_settings: _log_analysis.jobCustomSettingsRT
});
const setupMlModuleDatafeedOverridesRT = rt.object;
const setupMlModuleRequestParamsRT = rt.intersection([rt.strict({
  indexPatternName: rt.string,
  prefix: rt.string,
  startDatafeed: rt.boolean,
  jobOverrides: rt.array(setupMlModuleJobOverridesRT),
  datafeedOverrides: rt.array(setupMlModuleDatafeedOverridesRT),
  useDedicatedIndex: rt.boolean
}), rt.exact(rt.partial({
  query: rt.object
}))]);
const setupMlModuleRequestPayloadRT = rt.intersection([setupMlModuleTimeParamsRT, setupMlModuleRequestParamsRT]);
const setupErrorRT = rt.type({
  reason: rt.string,
  type: rt.string
});
const setupErrorResponseRT = rt.type({
  status: rt.number,
  error: rt.intersection([setupErrorRT, rt.type({
    root_cause: rt.array(setupErrorRT)
  })])
});
const datafeedSetupResponseRT = rt.intersection([rt.type({
  id: rt.string,
  started: rt.boolean,
  success: rt.boolean
}), rt.partial({
  awaitingNodeAssignment: rt.boolean,
  error: setupErrorResponseRT
})]);
const jobSetupResponseRT = rt.intersection([rt.type({
  id: rt.string,
  success: rt.boolean
}), rt.partial({
  error: setupErrorResponseRT
})]);
const setupMlModuleResponsePayloadRT = rt.type({
  datafeeds: rt.array(datafeedSetupResponseRT),
  jobs: rt.array(jobSetupResponseRT)
});