"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogStreamEmbeddable = exports.LOG_STREAM_EMBEDDABLE = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _rxjs = require("rxjs");
var _public = require("@kbn/embeddable-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _public2 = require("@kbn/logs-shared-plugin/public");
var _common_providers = require("../../apps/common_providers");
var _datemath = require("../../utils/datemath");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_STREAM_EMBEDDABLE = exports.LOG_STREAM_EMBEDDABLE = 'LOG_STREAM_EMBEDDABLE';
class LogStreamEmbeddable extends _public.Embeddable {
  constructor(core, pluginDeps, pluginStart, initialInput, parent) {
    var _core$theme;
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "type", LOG_STREAM_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "subscription", void 0);
    (0, _defineProperty2.default)(this, "isDarkMode", false);
    this.core = core;
    this.pluginDeps = pluginDeps;
    this.pluginStart = pluginStart;
    this.subscription = new _rxjs.Subscription();
    this.subscription.add((_core$theme = core.theme) === null || _core$theme === void 0 ? void 0 : _core$theme.theme$.subscribe(theme => this.isDarkMode = theme.darkMode));
    this.subscription.add(this.getInput$().subscribe(() => this.renderComponent()));
  }
  render(node) {
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
    this.node = node;
    this.renderComponent();
  }
  destroy() {
    super.destroy();
    this.subscription.unsubscribe();
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
  }
  async reload() {}
  renderComponent() {
    if (!this.node) {
      return;
    }
    const startTimestamp = (0, _datemath.datemathToEpochMillis)(this.input.timeRange.from);
    const endTimestamp = (0, _datemath.datemathToEpochMillis)(this.input.timeRange.to, 'up');
    if (!startTimestamp || !endTimestamp) {
      return;
    }
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_common_providers.CoreProviders, {
      core: this.core,
      plugins: this.pluginDeps,
      pluginStart: this.pluginStart,
      theme$: this.core.theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
      darkMode: this.isDarkMode
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '100%'
      }
    }, /*#__PURE__*/_react.default.createElement(_public2.LogStream, {
      logView: {
        type: 'log-view-reference',
        logViewId: 'default'
      },
      startTimestamp: startTimestamp,
      endTimestamp: endTimestamp,
      height: "100%",
      query: this.input.query,
      filters: this.input.filters
    })))), this.node);
  }
}
exports.LogStreamEmbeddable = LogStreamEmbeddable;