"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _use_kibana = require("../../hooks/use_kibana");
var _chart_placeholder = require("./chart_placeholder");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LensWrapper = ({
  attributes,
  dateRange,
  filters,
  searchSessionId,
  loading = false,
  onLoad,
  query,
  ...props
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [intersectionObserverEntry, setIntersectionObserverEntry] = (0, _react.useState)();
  const [embeddableLoaded, setEmbeddableLoaded] = (0, _react.useState)(false);
  const [state, setState] = (0, _react.useState)({
    attributes,
    dateRange,
    filters,
    query,
    searchSessionId
  });
  const ref = (0, _react.useRef)(null);
  const observerRef = (0, _react.useRef)(new IntersectionObserver(([value]) => setIntersectionObserverEntry(value), {
    root: ref.current
  }));
  (0, _react.useEffect)(() => {
    const {
      current: currentObserver
    } = observerRef;
    currentObserver.disconnect();
    const {
      current
    } = ref;
    if (current) {
      currentObserver.observe(current);
    }
    return () => currentObserver.disconnect();
  }, [ref]);
  (0, _react.useEffect)(() => {
    if (intersectionObserverEntry !== null && intersectionObserverEntry !== void 0 && intersectionObserverEntry.isIntersecting) {
      setState({
        attributes,
        dateRange,
        filters,
        query,
        searchSessionId
      });
    }
  }, [attributes, dateRange, filters, intersectionObserverEntry === null || intersectionObserverEntry === void 0 ? void 0 : intersectionObserverEntry.isIntersecting, query, searchSessionId]);
  const handleOnLoad = (0, _react.useCallback)(isLoading => {
    if (!embeddableLoaded) {
      setEmbeddableLoaded(true);
    }
    if (onLoad) {
      onLoad(isLoading);
    }
  }, [embeddableLoaded, onLoad]);
  const isLoading = loading || !state.attributes;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        position: relative;
        overflow: hidden;
        height: 100%;
        .echMetric {
          border-radius: ${euiTheme.border.radius.medium};
          pointer-events: none;
        }
      `,
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading && !embeddableLoaded ? /*#__PURE__*/_react.default.createElement(_chart_placeholder.ChartPlaceholder, {
    style: props.style
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading && /*#__PURE__*/_react.default.createElement(_chart_placeholder.ChartLoadingProgress, {
    hasTopMargin: !props.hidePanelTitles
  }), /*#__PURE__*/_react.default.createElement(EmbeddableComponentMemo, (0, _extends2.default)({}, props, {
    searchSessionId: state.searchSessionId,
    attributes: state.attributes,
    filters: state.filters,
    onLoad: handleOnLoad,
    query: state.query,
    timeRange: dateRange,
    viewMode: _public.ViewMode.VIEW
  })))));
};
exports.LensWrapper = LensWrapper;
const EmbeddableComponentMemo = /*#__PURE__*/_react.default.memo(({
  attributes,
  ...props
}) => {
  const {
    services: {
      lens
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const EmbeddableComponent = lens.EmbeddableComponent;
  if (!attributes) {
    return /*#__PURE__*/_react.default.createElement(_chart_placeholder.ChartPlaceholder, {
      style: props.style
    });
  }
  return /*#__PURE__*/_react.default.createElement(EmbeddableComponent, (0, _extends2.default)({}, props, {
    attributes: attributes
  }));
});