"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingLinks = ProfilingLinks;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PROFILING_FEEDBACK_URL = 'https://ela.st/profiling-feedback';
function ProfilingLinks({
  hostname,
  from,
  to,
  profilingLinkLocator,
  profilingLinkLabel
}) {
  const profilingLinkURL = profilingLinkLocator.getRedirectUrl({
    kuery: `${_constants.HOST_FIELD}:"${hostname}"`,
    rangeFrom: from,
    rangeTo: to
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "infraFlamegraphTestLink",
    href: profilingLinkURL
  }, profilingLinkLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "infraFlamegraphTestLink",
    href: PROFILING_FEEDBACK_URL,
    external: true,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.infra.flamegraph.profilingFeedbackLink', {
    defaultMessage: 'Give feedback'
  }))));
}