"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Flamegraph = Flamegraph;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_date_picker = require("../../hooks/use_date_picker");
var _use_profiling_flamegraph_data = require("../../hooks/use_profiling_flamegraph_data");
var _use_tab_switcher = require("../../hooks/use_tab_switcher");
var _types = require("../../types");
var _error_prompt = require("./error_prompt");
var _profiling_links = require("./profiling_links");
var _empty_data_prompt = require("./empty_data_prompt");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Flamegraph({
  kuery
}) {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    asset
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    activeTabId
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    dateRange,
    getDateRangeInTimestamp
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    from,
    to
  } = getDateRangeInTimestamp();
  const profilingLinkLocator = services.observabilityShared.locators.profiling.flamegraphLocator;
  const profilingLinkLabel = _i18n.i18n.translate('xpack.infra.flamegraph.profilingAppFlamegraphLink', {
    defaultMessage: 'Go to Universal Profiling Flamegraph'
  });
  const params = (0, _react.useMemo)(() => ({
    kuery,
    from,
    to
  }), [from, kuery, to]);
  const {
    error,
    loading,
    response
  } = (0, _use_profiling_flamegraph_data.useProfilingFlamegraphData)({
    isActive: activeTabId === _types.ContentTabIds.PROFILING,
    params
  });
  if (error !== null) {
    return /*#__PURE__*/_react.default.createElement(_error_prompt.ErrorPrompt, null);
  }
  if (!loading && (response === null || response === void 0 ? void 0 : response.TotalSamples) === 0) {
    return /*#__PURE__*/_react.default.createElement(_empty_data_prompt.EmptyDataPrompt, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_profiling_links.ProfilingLinks, {
    hostname: asset.name,
    from: dateRange.from,
    to: dateRange.to,
    profilingLinkLocator: profilingLinkLocator,
    profilingLinkLabel: profilingLinkLabel
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_public.EmbeddableFlamegraph, {
    data: response !== null && response !== void 0 ? response : undefined,
    isLoading: loading,
    height: "60vh"
  }));
}