"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddMetadataPinToRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PIN_FIELD = _i18n.i18n.translate('xpack.infra.metadataEmbeddable.pinField', {
  defaultMessage: 'Pin Field'
});
const AddMetadataPinToRow = ({
  fieldName,
  pinnedItems,
  onPinned
}) => {
  const handleAddPin = () => {
    onPinned([...pinnedItems, fieldName]);
  };
  const handleRemovePin = () => {
    if (pinnedItems && pinnedItems.includes(fieldName)) {
      onPinned((pinnedItems !== null && pinnedItems !== void 0 ? pinnedItems : []).filter(pinName => fieldName !== pinName));
    }
  };
  if (pinnedItems !== null && pinnedItems !== void 0 && pinnedItems.includes(fieldName)) {
    return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.infra.metadataEmbeddable.unpinField', {
        defaultMessage: 'Unpin field'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      color: "primary",
      iconType: "pinFilled",
      "data-test-subj": "infraAssetDetailsMetadataRemovePin",
      "aria-label": _i18n.i18n.translate('xpack.infra.metadata.pinAriaLabel', {
        defaultMessage: 'Pinned field'
      }),
      onClick: handleRemovePin
    })));
  }
  return /*#__PURE__*/_react.default.createElement("span", {
    className: "euiTableCellContent__hoverItem expandedItemActions__completelyHide"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: PIN_FIELD
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "primary",
    size: "s",
    iconType: "pin",
    "data-test-subj": "infraAssetDetailsMetadataAddPin",
    "aria-label": PIN_FIELD,
    onClick: handleAddPin
  })));
};
exports.AddMetadataPinToRow = AddMetadataPinToRow;