"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataExplanationMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _popover = require("../tabs/common/popover");
var _use_metadata_state = require("../hooks/use_metadata_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOSTNAME_DOCS_LINK = 'https://www.elastic.co/guide/en/ecs/current/ecs-host.html#field-host-name';
const MetadataExplanationTooltipContent = /*#__PURE__*/_react.default.memo(() => {
  const onClick = e => {
    e.stopPropagation();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    onClick: onClick,
    style: {
      width: 200
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.metadata.tooltip.documentationLabel",
    defaultMessage: "{metadata} is populated from the last event detected for this {hostName} for the selected date period.",
    values: {
      metadata: /*#__PURE__*/_react.default.createElement("i", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.metadata.tooltip.metadata",
        defaultMessage: "Metadata"
      })),
      hostName: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraAssetDetailsTooltipDocumentationLink",
        href: HOSTNAME_DOCS_LINK,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.metadata.tooltip.documentationLink",
        defaultMessage: "host.name"
      }))
    }
  }));
});
const MetadataExplanationMessage = () => {
  var _metadata$info, _metadata$info2, _metadata$info3;
  const {
    metadata,
    loading
  } = (0, _use_metadata_state.useMetadataStateContext)();
  return loading && !metadata ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : metadata !== null && metadata !== void 0 && (_metadata$info = metadata.info) !== null && _metadata$info !== void 0 && _metadata$info.timestamp ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "baseline",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.metadata.tooltip.metadataSectionTitle",
    defaultMessage: "Showing metadata collected on {date} @ {time}",
    values: {
      date: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: new Date(metadata === null || metadata === void 0 ? void 0 : (_metadata$info2 = metadata.info) === null || _metadata$info2 === void 0 ? void 0 : _metadata$info2.timestamp),
        month: "short",
        day: "numeric",
        year: "numeric"
      }),
      time: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
        value: new Date(metadata === null || metadata === void 0 ? void 0 : (_metadata$info3 = metadata.info) === null || _metadata$info3 === void 0 ? void 0 : _metadata$info3.timestamp),
        hour12: false,
        hour: "2-digit",
        minute: "2-digit",
        second: "2-digit"
      })
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    iconSize: "s",
    iconColor: "subdued",
    icon: "iInCircle",
    "data-test-subj": "infraAssetDetailsMetadataPopoverButton"
  }, /*#__PURE__*/_react.default.createElement(MetadataExplanationTooltipContent, null)))) : null;
};
exports.MetadataExplanationMessage = MetadataExplanationMessage;