"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableContent = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExpandableContent = props => {
  const {
    values
  } = props;
  const [isExpanded, toggle] = (0, _useToggle.default)(false);
  const list = Array.isArray(values) ? values : [values];
  const [first, ...others] = list;
  const hasOthers = others.length > 0;
  const shouldShowMore = hasOthers && !isExpanded;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    alignItems: "baseline",
    wrap: true,
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement("div", null, first, shouldShowMore && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ... ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "infraAssetDetailsExpandableContentCountMoreLink",
    onClick: toggle
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.tabs.metadata.seeMore",
    defaultMessage: "+{count} more",
    values: {
      count: others.length
    }
  })))), isExpanded && others.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, item)), hasOthers && isExpanded && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "infraExpandableContentShowLessLink",
    onClick: toggle
  }, _i18n.i18n.translate('xpack.infra.assetDetails.tabs.metadata.seeLess', {
    defaultMessage: 'Show less'
  }))));
};
exports.ExpandableContent = ExpandableContent;