"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Threshold = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../../common/alerting/logs/log_threshold/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const thresholdPrefix = _i18n.i18n.translate('xpack.infra.logs.alertFlyout.thresholdPrefix', {
  defaultMessage: 'is'
});
const popoverTitle = _i18n.i18n.translate('xpack.infra.logs.alertFlyout.thresholdPopoverTitle', {
  defaultMessage: 'Threshold'
});
const getComparatorOptions = () => {
  return [{
    value: _types.Comparator.LT,
    text: _types.ComparatorToi18nMap[_types.Comparator.LT]
  }, {
    value: _types.Comparator.LT_OR_EQ,
    text: _types.ComparatorToi18nMap[_types.Comparator.LT_OR_EQ]
  }, {
    value: _types.Comparator.GT,
    text: _types.ComparatorToi18nMap[_types.Comparator.GT]
  }, {
    value: _types.Comparator.GT_OR_EQ,
    text: _types.ComparatorToi18nMap[_types.Comparator.GT_OR_EQ]
  }];
};
const Threshold = ({
  comparator,
  value,
  updateThreshold,
  errors
}) => {
  const [isThresholdPopoverOpen, setThresholdPopoverOpenState] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "threshold",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: thresholdPrefix,
      uppercase: true,
      value: `${comparator ? _types.ComparatorToi18nMap[comparator] : ''} ${typeof value === 'number' ? value : ''}`,
      isActive: isThresholdPopoverOpen,
      onClick: () => setThresholdPopoverOpenState(!isThresholdPopoverOpen)
    }),
    isOpen: isThresholdPopoverOpen,
    closePopover: () => setThresholdPopoverOpenState(false),
    ownFocus: true,
    panelPaddingSize: "s",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, popoverTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "infraThresholdSelect",
    compressed: true,
    value: comparator,
    onChange: e => updateThreshold({
      comparator: e.target.value
    }),
    options: getComparatorOptions()
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: errors.value.length > 0,
    error: errors.value
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "infraThresholdFieldNumber",
    compressed: true,
    value: value,
    onChange: e => {
      const number = parseFloat(e.target.value);
      updateThreshold({
        value: (0, _lodash.isNumber)(number) && (0, _lodash.isFinite)(number) ? number : undefined
      });
    }
  }))))))));
};
exports.Threshold = Threshold;