"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLocationToDiscover = exports.createSearchString = void 0;
var _common = require("@kbn/logs-shared-plugin/common");
var _lodash = require("lodash");
var _constants = require("../constants");
var _url_state_storage_service = require("../url_state_storage_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSearchString = ({
  time,
  timeRange,
  filter = '',
  logView = _common.DEFAULT_LOG_VIEW
}) => {
  return (0, _lodash.flowRight)((0, _url_state_storage_service.replaceLogFilterInQueryString)({
    language: 'kuery',
    query: filter
  }, time, timeRange), (0, _url_state_storage_service.replaceLogPositionInQueryString)(time), (0, _url_state_storage_service.replaceLogViewInQueryString)(logView))('');
};
exports.createSearchString = createSearchString;
const getLocationToDiscover = async ({
  core,
  timeRange,
  filter,
  logView = _common.DEFAULT_LOG_VIEW
}) => {
  const [, plugins] = await core.getStartServices();
  const {
    discover,
    logsShared
  } = plugins;
  const {
    logViews
  } = logsShared;
  const resolvedLogView = await logViews.client.getResolvedLogView(logView);
  const discoverParams = {
    ...(timeRange ? {
      from: timeRange.startTime,
      to: timeRange.endTime
    } : {}),
    ...(filter ? {
      query: {
        language: 'kuery',
        query: filter
      }
    } : {})
  };
  const discoverLocation = await constructDiscoverLocation(discover, discoverParams, resolvedLogView);
  if (!discoverLocation) {
    throw new Error('Discover location not found');
  }
  return discoverLocation;
};
exports.getLocationToDiscover = getLocationToDiscover;
const constructDiscoverLocation = async (discover, discoverParams, resolvedLogView) => {
  var _discover$locator2;
  if (!resolvedLogView) {
    var _discover$locator;
    return await ((_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.getLocation(discoverParams));
  }
  const columns = parseColumns(resolvedLogView.columns);
  const dataViewSpec = resolvedLogView.dataViewReference.toSpec();
  return await ((_discover$locator2 = discover.locator) === null || _discover$locator2 === void 0 ? void 0 : _discover$locator2.getLocation({
    ...discoverParams,
    columns,
    dataViewId: dataViewSpec.id,
    dataViewSpec
  }));
};
const parseColumns = columns => {
  return columns.map(getColumnValue).filter(Boolean);
};
const getColumnValue = column => {
  if ('messageColumn' in column) return _constants.MESSAGE_FIELD;
  if ('timestampColumn' in column) return _constants.TIMESTAMP_FIELD;
  if ('fieldColumn' in column) return column.fieldColumn.field;
  return null;
};