"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTemplateListLink = exports.getTemplateEditLink = exports.getTemplateDetailsLink = exports.getTemplateCloneLink = exports.getIndexListUri = exports.getIndexDetailsLink = exports.getDataStreamDetailsLink = exports.getComponentTemplatesLink = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTemplateListLink = () => `/templates`;
exports.getTemplateListLink = getTemplateListLink;
const getTemplateDetailsLink = (name, isLegacy) => {
  let url = `/templates/${encodeURIComponent(name)}`;
  if (isLegacy) {
    url = `${url}?legacy=${isLegacy}`;
  }
  return encodeURI(url);
};
exports.getTemplateDetailsLink = getTemplateDetailsLink;
const getTemplateEditLink = (name, isLegacy) => {
  let url = `/edit_template/${encodeURIComponent(name)}`;
  if (isLegacy) {
    url = `${url}?legacy=true`;
  }
  return encodeURI(url);
};
exports.getTemplateEditLink = getTemplateEditLink;
const getTemplateCloneLink = (name, isLegacy) => {
  let url = `/clone_template/${encodeURIComponent(name)}`;
  if (isLegacy) {
    url = `${url}?legacy=true`;
  }
  return encodeURI(url);
};
exports.getTemplateCloneLink = getTemplateCloneLink;
const getIndexListUri = (filter, includeHiddenIndices) => {
  let url = `/${_constants.Section.Indices}`;
  const hiddenIndicesParam = typeof includeHiddenIndices !== 'undefined' ? includeHiddenIndices : false;
  if (hiddenIndicesParam) {
    url = `${url}?includeHiddenIndices=${hiddenIndicesParam}`;
  }
  if (filter && filter !== 'undefined') {
    // React router tries to decode url params but it can't because the browser partially
    // decodes them. So we have to encode both the URL and the filter to get it all to
    // work correctly for filters with URL unsafe characters in them.
    url = `${url}${hiddenIndicesParam ? '&' : '?'}filter=${encodeURIComponent(filter)}`;
  }
  return url;
};
exports.getIndexListUri = getIndexListUri;
const getDataStreamDetailsLink = name => {
  return encodeURI(`/data_streams/${encodeURIComponent(name)}`);
};
exports.getDataStreamDetailsLink = getDataStreamDetailsLink;
const getIndexDetailsLink = (indexName, indicesListURLParams, tab) => {
  let link = `/${_constants.Section.Indices}/index_details?indexName=${encodeURIComponent(indexName)}`;
  if (indicesListURLParams) {
    link = `${link}&${indicesListURLParams.replace('?', '')}`;
  }
  if (tab) {
    link = `${link}&tab=${tab}`;
  }
  return link;
};
exports.getIndexDetailsLink = getIndexDetailsLink;
const getComponentTemplatesLink = usedByTemplateName => {
  let url = '/component_templates';
  if (usedByTemplateName) {
    const filter = `usedBy=(${usedByTemplateName})`;
    url = `${url}?filter=${encodeURIComponent(filter)}`;
  }
  return url;
};
exports.getComponentTemplatesLink = getComponentTemplatesLink;