"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlattenedType = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../shared_imports");
var _lib = require("../../../../lib");
var _constants = require("../../../../constants");
var _field_parameters = require("../../field_parameters");
var _edit_field = require("../edit_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultToggleValue = (param, field) => {
  switch (param) {
    case 'boost':
    case 'ignore_above':
    case 'meta':
    case 'similarity':
      {
        return field[param] !== undefined && field[param] !== (0, _lib.getFieldConfig)(param).defaultValue;
      }
    case 'null_value':
      {
        return field.null_value !== undefined && field.null_value !== '';
      }
    default:
      return false;
  }
};
const FlattenedType = exports.FlattenedType = /*#__PURE__*/_react.default.memo(({
  field,
  kibanaVersion
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_edit_field.BasicParametersSection, null, /*#__PURE__*/_react.default.createElement(_field_parameters.IndexParameter, {
    config: (0, _lib.getFieldConfig)('index_options_flattened'),
    indexOptions: _constants.PARAMETERS_OPTIONS.index_options_flattened
  })), /*#__PURE__*/_react.default.createElement(_edit_field.AdvancedParametersSection, null, /*#__PURE__*/_react.default.createElement(_field_parameters.EagerGlobalOrdinalsParameter, null), /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.depthLimitTitle', {
      defaultMessage: 'Customize depth limit'
    }),
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.depthLimitDescription', {
      defaultMessage: 'The maximum allowed depth of the flattened object field, in terms of nested inner objects. Defaults to 20.'
    })
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "depth_limit",
    config: (0, _lib.getFieldConfig)('depth_limit'),
    component: _shared_imports.Field
  })), /*#__PURE__*/_react.default.createElement(_field_parameters.IgnoreAboveParameter, {
    defaultToggleValue: getDefaultToggleValue('ignore_above', field.source)
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.SplitQueriesOnWhitespaceParameter, null), /*#__PURE__*/_react.default.createElement(_field_parameters.SimilarityParameter, {
    defaultToggleValue: getDefaultToggleValue('similarity', field.source)
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.DocValuesParameter, null), /*#__PURE__*/_react.default.createElement(_field_parameters.NullValueParameter, {
    defaultToggleValue: getDefaultToggleValue('null_value', field.source)
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.MetaParameter, {
    defaultToggleValue: getDefaultToggleValue('meta', field.source)
  }), kibanaVersion.major < 8 && /*#__PURE__*/_react.default.createElement(_field_parameters.BoostParameter, {
    defaultToggleValue: getDefaultToggleValue('boost', field.source)
  })));
});