"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteFieldProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _mappings_state_context = require("../../../mappings_state_context");
var _lib = require("../../../lib");
var _modal_confirmation_delete_fields = require("./modal_confirmation_delete_fields");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteFieldProvider = ({
  children
}) => {
  const [state, setState] = (0, _react.useState)({
    isModalOpen: false
  });
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    fields
  } = (0, _mappings_state_context.useMappingsState)();
  const {
    byId
  } = fields;
  const confirmButtonText = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.deleteField.confirmationModal.removeButtonLabel', {
    defaultMessage: 'Remove'
  });
  let modalTitle;
  if (state.field) {
    const {
      isMultiField,
      source
    } = state.field;
    modalTitle = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.deleteField.confirmationModal.title', {
      defaultMessage: "Remove {fieldType} '{fieldName}'?",
      values: {
        fieldType: isMultiField ? 'multi-field' : 'field',
        fieldName: source.name
      }
    });
  }
  const deleteField = field => {
    const aliases = (0, _lib.getAllDescendantAliases)(field, fields).map(id => byId[id].path.join(' > ')).sort();
    const hasAliases = Boolean(aliases.length);
    setState({
      isModalOpen: true,
      field,
      aliases: hasAliases ? aliases : undefined
    });
  };
  const closeModal = () => {
    setState({
      isModalOpen: false
    });
  };
  const confirmDelete = () => {
    dispatch({
      type: 'field.remove',
      value: state.field.id
    });
    closeModal();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children(deleteField), state.isModalOpen && /*#__PURE__*/_react.default.createElement(_modal_confirmation_delete_fields.ModalConfirmationDeleteFields, {
    title: modalTitle,
    childFields: state.field && state.field.childFields,
    aliases: state.aliases,
    byId: byId,
    confirmButtonText: confirmButtonText,
    onConfirm: confirmDelete,
    onCancel: closeModal
  }));
};
exports.DeleteFieldProvider = DeleteFieldProvider;