"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getImageEmbeddableFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _actions = require("../actions");
var _open_image_editor = require("../components/image_editor/open_image_editor");
var _image_embeddable = require("../components/image_embeddable");
var _kibana_services = require("../services/kibana_services");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getImageEmbeddableFactory = ({
  embeddableEnhanced
}) => {
  const imageEmbeddableFactory = {
    type: _constants.IMAGE_EMBEDDABLE_TYPE,
    deserializeState: state => {
      return state.rawState;
    },
    buildEmbeddable: async (initialState, buildApi, uuid) => {
      var _dynamicActionsApi$dy, _dynamicActionsApi$dy2;
      const {
        titlesApi,
        titleComparators,
        serializeTitles
      } = (0, _presentationPublishing.initializeTitles)(initialState);
      const dynamicActionsApi = embeddableEnhanced === null || embeddableEnhanced === void 0 ? void 0 : embeddableEnhanced.initializeReactEmbeddableDynamicActions(uuid, () => titlesApi.panelTitle.getValue(), initialState);
      // if it is provided, start the dynamic actions manager
      const maybeStopDynamicActions = dynamicActionsApi === null || dynamicActionsApi === void 0 ? void 0 : dynamicActionsApi.startDynamicActions();
      const filesClient = _kibana_services.filesService.filesClientFactory.asUnscoped();
      const imageConfig$ = new _rxjs.BehaviorSubject(initialState.imageConfig);
      const dataLoading$ = new _rxjs.BehaviorSubject(true);
      const embeddable = buildApi({
        ...titlesApi,
        ...((_dynamicActionsApi$dy = dynamicActionsApi === null || dynamicActionsApi === void 0 ? void 0 : dynamicActionsApi.dynamicActionsApi) !== null && _dynamicActionsApi$dy !== void 0 ? _dynamicActionsApi$dy : {}),
        dataLoading: dataLoading$,
        supportedTriggers: () => [_actions.IMAGE_CLICK_TRIGGER],
        onEdit: async () => {
          try {
            const newImageConfig = await (0, _open_image_editor.openImageEditor)({
              parentApi: embeddable.parentApi,
              initialImageConfig: imageConfig$.getValue()
            });
            imageConfig$.next(newImageConfig);
          } catch {
            // swallow the rejection, since this just means the user closed without saving
          }
        },
        isEditingEnabled: () => true,
        getTypeDisplayName: () => _i18n.i18n.translate('imageEmbeddable.imageEmbeddableFactory.displayName.edit', {
          defaultMessage: 'image'
        }),
        serializeState: () => {
          var _dynamicActionsApi$se;
          return {
            rawState: {
              ...serializeTitles(),
              ...((_dynamicActionsApi$se = dynamicActionsApi === null || dynamicActionsApi === void 0 ? void 0 : dynamicActionsApi.serializeDynamicActions()) !== null && _dynamicActionsApi$se !== void 0 ? _dynamicActionsApi$se : {}),
              imageConfig: imageConfig$.getValue()
            }
          };
        }
      }, {
        ...titleComparators,
        ...((_dynamicActionsApi$dy2 = dynamicActionsApi === null || dynamicActionsApi === void 0 ? void 0 : dynamicActionsApi.dynamicActionsComparator) !== null && _dynamicActionsApi$dy2 !== void 0 ? _dynamicActionsApi$dy2 : {}),
        imageConfig: [imageConfig$, value => imageConfig$.next(value), (a, b) => (0, _reactFastCompare.default)(a, b)]
      });
      return {
        api: embeddable,
        Component: () => {
          const privateImageEmbeddableApi = (0, _react.useMemo)(() => {
            /** Memoize the API so that the reference stays consistent and it can be used as a dependency */
            return {
              ...embeddable,
              imageConfig$,
              setDataLoading: loading => dataLoading$.next(loading)
            };
          }, []);
          (0, _react.useEffect)(() => {
            return () => {
              // if it was started, stop the dynamic actions manager on unmount
              maybeStopDynamicActions === null || maybeStopDynamicActions === void 0 ? void 0 : maybeStopDynamicActions.stopDynamicActions();
            };
          }, []);
          return /*#__PURE__*/_react.default.createElement(_image_embeddable.ImageEmbeddable, {
            api: privateImageEmbeddableApi,
            filesClient: filesClient
          });
        }
      };
    }
  };
  return imageEmbeddableFactory;
};
exports.getImageEmbeddableFactory = getImageEmbeddableFactory;