"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImageViewer = ImageViewer;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxFileImage = require("@kbn/shared-ux-file-image");
var _validate_image_config = require("../../utils/validate_image_config");
var _not_found_light = _interopRequireDefault(require("./assets/not_found_light.png"));
var _not_found_light2x = _interopRequireDefault(require("./assets/not_found_light@2x.png"));
var _image_viewer_context = require("./image_viewer_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ImageViewer({
  imageConfig,
  onChange,
  onClear,
  onError,
  onLoad,
  onClick,
  className,
  containerCSS,
  isScreenshotMode,
  ...rest
}) {
  var _imageConfig$altText, _imageConfig$sizing$o, _imageConfig$sizing;
  const {
    getImageDownloadHref,
    validateUrl
  } = (0, _image_viewer_context.useImageViewerContext)();
  const isImageConfigValid = (0, _validate_image_config.validateImageConfig)(imageConfig, {
    validateUrl
  });
  const src = imageConfig.src.type === 'url' ? imageConfig.src.url : getImageDownloadHref(imageConfig.src.fileId);
  const [hasFailedToLoad, setFailedToLoad] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setFailedToLoad(false);
  }, [src]);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, rest, {
    css: [(0, _react2.css)`
          position: relative;
          width: 100%;
          height: 100%;
          .visually-hidden {
            visibility: hidden;
          }
        `, containerCSS]
  }), (hasFailedToLoad || !isImageConfigValid) && /*#__PURE__*/_react.default.createElement(NotFound, null), isImageConfigValid && /*#__PURE__*/_react.default.createElement(_sharedUxFileImage.FileImage, {
    src: src
    // uncomment to enable blurhash when it's ready
    // https://github.com/elastic/kibana/issues/145567
    // meta={imageConfig.src.type === 'file' ? imageConfig.src.fileImageMeta : undefined}
    ,
    alt: (_imageConfig$altText = imageConfig.altText) !== null && _imageConfig$altText !== void 0 ? _imageConfig$altText : '',
    className: (0, _classnames.default)(className, {
      'visually-hidden': hasFailedToLoad
    }),
    title: onChange ? _i18n.i18n.translate('imageEmbeddable.imageViewer.selectDifferentImageTitle', {
      defaultMessage: 'Select a different image'
    }) : undefined,
    loading: isScreenshotMode ? 'eager' : 'lazy',
    style: {
      width: '100%',
      height: '100%',
      objectFit: (_imageConfig$sizing$o = imageConfig === null || imageConfig === void 0 ? void 0 : (_imageConfig$sizing = imageConfig.sizing) === null || _imageConfig$sizing === void 0 ? void 0 : _imageConfig$sizing.objectFit) !== null && _imageConfig$sizing$o !== void 0 ? _imageConfig$sizing$o : 'contain',
      cursor: onChange || onClick ? 'pointer' : 'initial',
      display: 'block',
      // needed to remove gap under the image
      backgroundColor: imageConfig.backgroundColor
    },
    wrapperProps: {
      style: {
        display: 'block',
        height: '100%',
        width: '100%'
      }
    },
    onClick: () => {
      if (onChange) onChange();
      if (onClick) onClick();
    },
    onLoad: () => {
      if (onLoad) onLoad();
    },
    onError: () => {
      setFailedToLoad(true);
      if (onError) onError();
    }
  }), onClear && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    style: {
      position: 'absolute',
      top: '-4px',
      right: '-4px'
    },
    display: "fill",
    iconType: "cross",
    "aria-label": "Clear",
    color: "danger",
    onClick: () => {
      if (onClear) onClear();
    }
  }));
}
function NotFound() {
  const [resizeRef, setRef] = _react.default.useState(null);
  const isLargeScreen = (0, _eui.useIsWithinBreakpoints)(['l', 'xl'], true);
  const dimensions = (0, _eui.useResizeObserver)(resizeRef);
  let mode = 'none';
  if (!resizeRef) {
    mode = 'none';
  } else if (dimensions.height > 200 && dimensions.width > 320 && isLargeScreen) {
    mode = 'image-and-text';
  } else {
    mode = 'only-image';
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: node => setRef(node),
    css: (0, _react2.css)`
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        .euiPanel,
        .euiEmptyPrompt__main {
          height: 100%;
          width: 100%;
          max-width: none;
        }
      `
  }, mode === 'only-image' && /*#__PURE__*/_react.default.createElement(NotFoundImage, {
    css: (0, _react2.css)`
            object-fit: contain;
            height: 100%;
            width: 100%;
          `,
    wrapperProps: {
      css: (0, _react2.css)`
              height: 100%;
              width: 100%;
            `
    }
  }), mode === 'image-and-text' && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "transparent",
    icon: /*#__PURE__*/_react.default.createElement(NotFoundImage, null),
    title: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "imageEmbeddable.imageViewer.notFoundTitle",
      defaultMessage: "Image not found"
    })),
    layout: "horizontal",
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "imageEmbeddable.imageViewer.notFoundMessage",
      defaultMessage: "We can't find the image you're looking for. It might have been removed, renamed, or it didn't exist in the first place."
    }))
  }));
}
const NotFoundImage = /*#__PURE__*/_react.default.memo(props => /*#__PURE__*/_react.default.createElement(_eui.EuiImage, (0, _extends2.default)({}, props, {
  "data-test-subj": `imageNotFound`,
  srcSet: `${_not_found_light.default} 1x, ${_not_found_light2x.default} 2x`,
  src: _not_found_light.default,
  alt: _i18n.i18n.translate('imageEmbeddable.imageViewer.notFoundImageAltText', {
    defaultMessage: `An outer space illustration. In the background is a large moon and two planets. In the foreground is an astronaut floating in space and the numbers '404'.`
  })
})));