"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GuidePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _quit_guide_modal = require("./quit_guide_modal");
var _guide_panel = require("./guide_panel.styles");
var _guide_button = require("./guide_button");
var _guide_panel_flyout = require("./guide_panel_flyout");
var _get_step_location = require("./get_step_location");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getProgress = state => {
  if (state) {
    return state.steps.reduce((acc, currentVal) => {
      if (currentVal.status === 'complete') {
        acc = acc + 1;
      }
      return acc;
    }, 0);
  }
  return 0;
};
const GuidePanel = ({
  api,
  application,
  notifications,
  theme$
}) => {
  var _pluginState$activeGu2;
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const euiTheme = euiThemeContext.euiTheme;
  const [isGuideOpen, setIsGuideOpen] = (0, _react.useState)(false);
  const [isQuitGuideModalOpen, setIsQuitGuideModalOpen] = (0, _react.useState)(false);
  const [pluginState, setPluginState] = (0, _react.useState)(undefined);
  const [guideConfig, setGuideConfig] = (0, _react.useState)(undefined);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    darkMode: isDarkTheme
  } = (0, _useObservable.default)(theme$, {
    darkMode: false
  });
  const styles = (0, _guide_panel.getGuidePanelStyles)({
    euiThemeContext,
    isDarkTheme
  });
  const toggleGuide = () => {
    setIsGuideOpen(prevIsGuideOpen => !prevIsGuideOpen);
  };
  const handleStepButtonClick = (0, _react.useCallback)(async (step, stepConfig) => {
    if (pluginState) {
      const {
        id,
        status
      } = step;
      const guideId = pluginState.activeGuide.guideId;
      try {
        if (status === 'ready_to_complete') {
          return await api.completeGuideStep(guideId, id);
        }
        if (status === 'active' || status === 'in_progress') {
          await api.startGuideStep(guideId, id);
          if (stepConfig.location) {
            var _stepConfig$manualCom;
            await application.navigateToApp(stepConfig.location.appID, {
              path: (0, _get_step_location.getStepLocationPath)(stepConfig.location.path, pluginState)
            });
            if ((_stepConfig$manualCom = stepConfig.manualCompletion) !== null && _stepConfig$manualCom !== void 0 && _stepConfig$manualCom.readyToCompleteOnNavigation) {
              await api.completeGuideStep(guideId, id);
            }
          }
        }
      } catch (error) {
        notifications.toasts.addDanger({
          title: _i18n.i18n.translate('guidedOnboarding.dropdownPanel.stepHandlerError', {
            defaultMessage: 'Unable to update the guide. Wait a moment and try again.'
          }),
          text: error.message
        });
      }
    }
  }, [api, application, notifications.toasts, pluginState]);
  const navigateToLandingPage = () => {
    setIsGuideOpen(false);
    application.navigateToApp('home', {
      path: '#getting_started'
    });
  };
  const completeGuide = async completedGuideRedirectLocation => {
    try {
      await api.completeGuide(pluginState.activeGuide.guideId);
      if (completedGuideRedirectLocation) {
        const {
          appID,
          path
        } = completedGuideRedirectLocation;
        application.navigateToApp(appID, {
          path
        });
      }
    } catch (error) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('guidedOnboarding.dropdownPanel.completeGuideError', {
          defaultMessage: 'Unable to update the guide. Wait a moment and try again.'
        }),
        text: error.message
      });
    }
  };
  const openQuitGuideModal = () => {
    // Close the dropdown panel
    setIsGuideOpen(false);
    // Open the confirmation modal
    setIsQuitGuideModalOpen(true);
  };
  const closeQuitGuideModal = () => {
    setIsQuitGuideModalOpen(false);
  };
  (0, _react.useEffect)(() => {
    const subscription = api.fetchPluginState$().subscribe(newPluginState => {
      setPluginState(newPluginState);
    });
    return () => subscription.unsubscribe();
  }, [api]);
  (0, _react.useEffect)(() => {
    const subscription = api.isLoading$.subscribe(isLoadingValue => {
      setIsLoading(isLoadingValue);
    });
    return () => subscription.unsubscribe();
  }, [api]);
  (0, _react.useEffect)(() => {
    const subscription = api.isGuidePanelOpen$.subscribe(isGuidePanelOpen => {
      setIsGuideOpen(isGuidePanelOpen);
    });
    return () => subscription.unsubscribe();
  }, [api]);
  const fetchGuideConfig = (0, _react.useCallback)(async () => {
    var _pluginState$activeGu;
    if (pluginState !== null && pluginState !== void 0 && (_pluginState$activeGu = pluginState.activeGuide) !== null && _pluginState$activeGu !== void 0 && _pluginState$activeGu.guideId) {
      const config = await api.getGuideConfig(pluginState.activeGuide.guideId);
      if (config) {
        setGuideConfig(config);
      }
    }
  }, [api, pluginState]);
  (0, _react.useEffect)(() => {
    fetchGuideConfig();
  }, [fetchGuideConfig]);
  const stepsCompleted = getProgress(pluginState === null || pluginState === void 0 ? void 0 : pluginState.activeGuide);
  const isGuideReadyToComplete = (pluginState === null || pluginState === void 0 ? void 0 : (_pluginState$activeGu2 = pluginState.activeGuide) === null || _pluginState$activeGu2 === void 0 ? void 0 : _pluginState$activeGu2.status) === 'ready_to_complete';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.setupButton
  }, /*#__PURE__*/_react.default.createElement(_guide_button.GuideButton, {
    isLoading: isLoading,
    pluginState: pluginState,
    guideConfig: guideConfig,
    toggleGuidePanel: toggleGuide,
    isGuidePanelOpen: isGuideOpen,
    navigateToLandingPage: navigateToLandingPage
  })), /*#__PURE__*/_react.default.createElement(_guide_panel_flyout.GuidePanelFlyout, {
    isOpen: isGuideOpen,
    isLoading: isLoading,
    styles: styles,
    toggleGuide: toggleGuide,
    isDarkTheme: isDarkTheme,
    stepsCompleted: stepsCompleted,
    isGuideReadyToComplete: isGuideReadyToComplete,
    guideConfig: guideConfig,
    navigateToLandingPage: navigateToLandingPage,
    pluginState: pluginState,
    handleStepButtonClick: handleStepButtonClick,
    openQuitGuideModal: openQuitGuideModal,
    euiTheme: euiTheme,
    completeGuide: completeGuide
  }), isQuitGuideModalOpen && /*#__PURE__*/_react.default.createElement(_quit_guide_modal.QuitGuideModal, {
    closeModal: closeQuitGuideModal,
    currentGuide: pluginState.activeGuide,
    telemetryGuideId: guideConfig.telemetryId,
    notifications: notifications
  }));
};
exports.GuidePanel = GuidePanel;