"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GuideButtonPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const GuideButtonPopover = ({
  button,
  isGuidePanelOpen,
  title,
  description
}) => {
  const isFirstRender = (0, _react.useRef)(true);
  (0, _react.useEffect)(() => {
    isFirstRender.current = false;
  }, []);
  const [isPopoverShown, setIsPopoverShown] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    // close the popover after it was rendered once and the panel is opened
    if (isGuidePanelOpen && !isFirstRender.current) {
      setIsPopoverShown(false);
    }
  }, [isGuidePanelOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "manualCompletionPopover",
    button: button,
    isOpen: isPopoverShown,
    repositionOnScroll: true,
    closePopover: () => {
      /* do nothing, the popover is closed once the panel is opened */
    }
  }, title && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    style: {
      width: 300
    }
  }, description && /*#__PURE__*/_react.default.createElement("p", null, description)));
};
exports.GuideButtonPopover = GuideButtonPopover;