"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlTemplateForm = UrlTemplateForm;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _classnames = _interopRequireDefault(require("classnames"));
var _outlink_encoders = require("../../helpers/outlink_encoders");
var _style_choices = require("../../helpers/style_choices");
var _url_template = require("../../helpers/url_template");
var _helpers = require("../helpers");
var _icon_renderer = require("../icon_renderer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isUpdateForm(props) {
  return 'initialTemplate' in props;
}
function UrlTemplateForm(props) {
  const {
    onSubmit
  } = props;
  const getInitialTemplate = () => isUpdateForm(props) ? props.initialTemplate : {
    encoder: _outlink_encoders.outlinkEncoders[0],
    icon: null,
    description: '',
    url: ''
  };
  const [currentTemplate, setCurrentTemplate] = (0, _react.useState)(getInitialTemplate);
  const persistedTemplateState = isUpdateForm(props) && props.initialTemplate;

  // reset local form if template passed in from parent component changes
  (0, _react.useEffect)(() => {
    if (isUpdateForm(props) && currentTemplate !== props.initialTemplate) {
      setCurrentTemplate(props.initialTemplate);
    }
    // this hook only updates on change of the prop
    // it's meant to reset the internal state on changes outside of the component.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [persistedTemplateState]);
  const [touched, setTouched] = (0, _react.useState)({
    description: false,
    url: false
  });
  const [open, setOpen] = (0, _react.useState)(!isUpdateForm(props));
  const [autoformatUrl, setAutoformatUrl] = (0, _react.useState)(false);
  function setValue(key, value) {
    setCurrentTemplate({
      ...currentTemplate,
      [key]: value
    });
  }
  function reset() {
    setTouched({
      description: false,
      url: false
    });
    setCurrentTemplate(getInitialTemplate());
    setAutoformatUrl(false);
  }
  function convertUrl() {
    setCurrentTemplate({
      ...currentTemplate,
      url: (0, _url_template.replaceKibanaUrlParam)(currentTemplate.url),
      // reset to kql encoder
      encoder: currentTemplate.encoder.type === 'kql' ? currentTemplate.encoder : _outlink_encoders.outlinkEncoders.find(enc => enc.type === 'kql')
    });
    setAutoformatUrl(false);
  }
  const urlPlaceholderMissing = Boolean(currentTemplate.url && !(0, _url_template.isUrlTemplateValid)(currentTemplate.url));
  const formIncomplete = !Boolean(currentTemplate.description && currentTemplate.url);
  const formUntouched = (0, _helpers.isEqual)(currentTemplate, getInitialTemplate());
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: props.id,
    initialIsOpen: !isUpdateForm(props),
    buttonContent: isUpdateForm(props) ? props.initialTemplate.description : _i18n.i18n.translate('xpack.graph.templates.addLabel', {
      defaultMessage: 'New drilldown'
    }),
    extraAction: isUpdateForm(props) && props.initialTemplate.icon && /*#__PURE__*/_react.default.createElement(_icon_renderer.IconRenderer, {
      icon: props.initialTemplate.icon,
      className: "gphLegacyIcon gphLegacyIcon--list"
    }),
    className: (0, _classnames.default)('gphUrlTemplateList__accordion', {
      'gphUrlTemplateList__accordion--isOpen': open
    }),
    buttonClassName: "gphUrlTemplateList__accordionbutton",
    onToggle: isOpen => {
      setOpen(isOpen);
    },
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: e => {
      e.preventDefault();
      onSubmit(currentTemplate);
      if (!isUpdateForm(props)) {
        reset();
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.graph.settings.drillDowns.urlDescriptionInputLabel', {
      defaultMessage: 'Title'
    }),
    isInvalid: touched.description && !currentTemplate.description,
    onBlur: () => setTouched({
      ...touched,
      description: true
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: currentTemplate.description,
    isInvalid: touched.description && !currentTemplate.description,
    onChange: e => setValue('description', e.target.value),
    placeholder: _i18n.i18n.translate('xpack.graph.settings.drillDowns.urlDescriptionInputPlaceholder', {
      defaultMessage: 'Search on Google'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.graph.settings.drillDowns.urlInputLabel', {
      defaultMessage: 'URL'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, autoformatUrl && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.graph.settings.drillDowns.kibanaUrlWarningText', {
      defaultMessage: 'Possible Kibana URL pasted, '
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: convertUrl
    }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.graph.settings.drillDowns.kibanaUrlWarningConvertOptionLinkText', {
      defaultMessage: 'convert it.'
    }))))), _i18n.i18n.translate('xpack.graph.settings.drillDowns.urlInputHelpText', {
      defaultMessage: 'Define template URLs using {gquery} where the selected vertex terms are inserted.',
      values: {
        gquery: '{{gquery}}'
      }
    })),
    onBlur: () => setTouched({
      ...touched,
      url: true
    }),
    isInvalid: urlPlaceholderMissing || touched.url && !currentTemplate.url,
    error: urlPlaceholderMissing ? [_i18n.i18n.translate('xpack.graph.settings.drillDowns.invalidUrlWarningText', {
      defaultMessage: 'The URL must contain a {placeholder} string.',
      values: {
        placeholder: '{{gquery}}'
      }
    })] : []
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    placeholder: "https://www.google.co.uk/#q={{gquery}}",
    value: currentTemplate.url,
    onChange: e => {
      var _e$nativeEvent;
      setValue('url', e.target.value);
      if (((_e$nativeEvent = e.nativeEvent) === null || _e$nativeEvent === void 0 ? void 0 : _e$nativeEvent.inputType) !== 'insertFromPaste' || !(0, _url_template.isKibanaUrl)(e.target.value)) {
        setAutoformatUrl(false);
      }
    },
    onPaste: e => {
      const pastedUrl = e.clipboardData.getData('text/plain');
      if ((0, _url_template.isKibanaUrl)(pastedUrl)) {
        setAutoformatUrl(true);
      }
    },
    isInvalid: urlPlaceholderMissing || touched.url && !currentTemplate.url
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: currentTemplate.encoder.description,
    label: _i18n.i18n.translate('xpack.graph.settings.drillDowns.urlEncoderInputLabel', {
      defaultMessage: 'URL parameter type'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: {
      asPlainText: true
    },
    isClearable: false,
    options: _outlink_encoders.outlinkEncoders.map(encoder => ({
      label: encoder.title,
      value: encoder
    })),
    selectedOptions: [{
      label: currentTemplate.encoder.title,
      value: currentTemplate.encoder
    }],
    onChange: choices => {
      // choices[0].value can't be null because `isClearable` is set to false above
      setValue('encoder', choices[0].value);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.graph.settings.drillDowns.toolbarIconPickerLabel', {
      defaultMessage: 'Toolbar icon'
    })
  }, /*#__PURE__*/_react.default.createElement("div", {
    role: "listbox",
    "aria-label": _i18n.i18n.translate('xpack.graph.settings.drillDowns.toolbarIconPickerSelectionAriaLabel', {
      defaultMessage: 'Toolbar icon selection'
    })
  }, _style_choices.urlTemplateIconChoices.map(icon => /*#__PURE__*/_react.default.createElement(_icon_renderer.IconRenderer, {
    icon: icon,
    onClick: () => {
      if (currentTemplate.icon === icon) {
        setValue('icon', null);
      } else {
        setValue('icon', icon);
      }
    },
    className: (0, _classnames.default)('gphLegacyIcon gphLegacyIcon--pickable', {
      'gphLegacyIcon--selected': icon === currentTemplate.icon
    })
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    onClick: () => {
      props.onRemove();
    },
    "data-test-subj": "graphRemoveUrlTemplate"
  }, isUpdateForm(props) ? _i18n.i18n.translate('xpack.graph.settings.drillDowns.removeButtonLabel', {
    defaultMessage: 'Remove'
  }) : _i18n.i18n.translate('xpack.graph.settings.drillDowns.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: reset,
    disabled: formUntouched
  }, _i18n.i18n.translate('xpack.graph.settings.drillDowns.resetButtonLabel', {
    defaultMessage: 'Reset'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    fill: true,
    isDisabled: urlPlaceholderMissing || formIncomplete
  }, isUpdateForm(props) ? _i18n.i18n.translate('xpack.graph.settings.drillDowns.updateSaveButtonLabel', {
    defaultMessage: 'Update drilldown'
  }) : _i18n.i18n.translate('xpack.graph.settings.drillDowns.newSaveButtonLabel', {
    defaultMessage: 'Save drilldown'
  }))))));
}