"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apiError = _configSchema.schema.object({
  error: _configSchema.schema.string(),
  message: _configSchema.schema.string(),
  statusCode: _configSchema.schema.number(),
  metadata: _configSchema.schema.object({}, {
    unknowns: 'allow'
  })
});
const referenceSchema = _configSchema.schema.object({
  name: _configSchema.schema.maybe(_configSchema.schema.string()),
  type: _configSchema.schema.string(),
  id: _configSchema.schema.string()
}, {
  unknowns: 'forbid'
});
const referencesSchema = _configSchema.schema.arrayOf(referenceSchema);
const graphAttributesSchema = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  version: _configSchema.schema.maybe(_configSchema.schema.number()),
  numLinks: _configSchema.schema.number(),
  numVertices: _configSchema.schema.number(),
  kibanaSavedObjectMeta: _configSchema.schema.maybe(_configSchema.schema.any()),
  wsState: _configSchema.schema.maybe(_configSchema.schema.string()),
  legacyIndexPatternRef: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  unknowns: 'forbid'
});
const graphSavedObjectSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  version: _configSchema.schema.maybe(_configSchema.schema.string()),
  createdAt: _configSchema.schema.maybe(_configSchema.schema.string()),
  updatedAt: _configSchema.schema.maybe(_configSchema.schema.string()),
  error: _configSchema.schema.maybe(apiError),
  attributes: graphAttributesSchema,
  references: referencesSchema,
  namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  originId: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  unknowns: 'allow'
});
const getResultSchema = _configSchema.schema.object({
  item: graphSavedObjectSchema,
  meta: _configSchema.schema.object({
    outcome: _configSchema.schema.oneOf([_configSchema.schema.literal('exactMatch'), _configSchema.schema.literal('aliasMatch'), _configSchema.schema.literal('conflict')]),
    aliasTargetId: _configSchema.schema.maybe(_configSchema.schema.string()),
    aliasPurpose: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('savedObjectConversion'), _configSchema.schema.literal('savedObjectImport')]))
  }, {
    unknowns: 'forbid'
  })
}, {
  unknowns: 'forbid'
});
const createOptionsSchema = _configSchema.schema.object({
  overwrite: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  references: _configSchema.schema.maybe(referencesSchema)
});

// Content management service definition.
// We need it for BWC support between different versions of the content
const serviceDefinition = exports.serviceDefinition = {
  get: {
    out: {
      result: {
        schema: getResultSchema
      }
    }
  },
  create: {
    in: {
      options: {
        schema: createOptionsSchema
      },
      data: {
        schema: graphAttributesSchema
      }
    },
    out: {
      result: {
        schema: _configSchema.schema.object({
          item: graphSavedObjectSchema
        }, {
          unknowns: 'forbid'
        })
      }
    }
  },
  update: {
    in: {
      options: {
        schema: createOptionsSchema // same schema as "create"
      },
      data: {
        schema: graphAttributesSchema
      }
    }
  },
  search: {
    in: {
      options: {
        schema: _configSchema.schema.maybe(_configSchema.schema.object({
          searchFields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
          types: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
        }, {
          unknowns: 'forbid'
        }))
      }
    }
  }
};