"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureAgentPoliciesFleetServerKeysAndPolicies = ensureAgentPoliciesFleetServerKeysAndPolicies;
var _pMap = _interopRequireDefault(require("p-map"));
var _agent_policy = require("../agent_policy");
var _api_keys = require("../api_keys");
var _constants = require("../../constants");
var _app_context = require("../app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function ensureAgentPoliciesFleetServerKeysAndPolicies({
  logger,
  soClient,
  esClient
}) {
  const security = _app_context.appContextService.getSecurity();
  if (!security) {
    return;
  }
  if (!(await security.authc.apiKeys.areAPIKeysEnabled())) {
    return;
  }
  const {
    items: agentPolicies
  } = await _agent_policy.agentPolicyService.list(soClient, {
    perPage: _constants.SO_SEARCH_LIMIT
  });
  const outdatedAgentPolicyIds = [];
  await (0, _pMap.default)(agentPolicies, async agentPolicy => {
    var _latestFleetPolicy$re;
    const [latestFleetPolicy] = await Promise.all([_agent_policy.agentPolicyService.getLatestFleetPolicy(esClient, agentPolicy.id), (0, _api_keys.ensureDefaultEnrollmentAPIKeyForAgentPolicy)(soClient, esClient, agentPolicy.id)]);
    if (((_latestFleetPolicy$re = latestFleetPolicy === null || latestFleetPolicy === void 0 ? void 0 : latestFleetPolicy.revision_idx) !== null && _latestFleetPolicy$re !== void 0 ? _latestFleetPolicy$re : -1) < agentPolicy.revision) {
      outdatedAgentPolicyIds.push(agentPolicy.id);
    }
  }, {
    concurrency: 20
  });
  if (outdatedAgentPolicyIds.length) {
    await _agent_policy.agentPolicyService.deployPolicies(soClient, outdatedAgentPolicyIds).catch(error => {
      logger.warn(`Error deploying policies: ${error.message}`, {
        error
      });
    });
  }
}