"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateLatestExecutedState = void 0;
var _server = require("@kbn/core/server");
var _constants = require("../../../../../constants");
var _audit_logging = require("../../../../audit_logging");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Function invoked after each transition
const updateLatestExecutedState = async context => {
  const {
    logger,
    savedObjectsClient,
    packageInstallContext,
    latestExecutedState
  } = context;
  const {
    packageInfo
  } = packageInstallContext;
  const {
    name: pkgName
  } = packageInfo;
  try {
    var _latestExecutedState$;
    // if there is no error avoid updating the SO as the call adds ~1s to install time
    // also don't save it if the error is of type ConcurrentInstallationError
    if (!(latestExecutedState !== null && latestExecutedState !== void 0 && latestExecutedState.error) || latestExecutedState !== null && latestExecutedState !== void 0 && (_latestExecutedState$ = latestExecutedState.error) !== null && _latestExecutedState$ !== void 0 && _latestExecutedState$.includes('Concurrent installation or upgrade')) return;
    _audit_logging.auditLoggingService.writeCustomSoAuditLog({
      action: 'update',
      id: pkgName,
      savedObjectType: _constants.PACKAGES_SAVED_OBJECT_TYPE
    });
    return await (0, _utils.withPackageSpan)('Update latest executed state', () => savedObjectsClient.update(_constants.PACKAGES_SAVED_OBJECT_TYPE, pkgName, {
      latest_executed_state: latestExecutedState
    }));
  } catch (err) {
    if (!_server.SavedObjectsErrorHelpers.isNotFoundError(err)) {
      logger.error(`Failed to update SO with latest executed state: ${err}`);
    }
  }
};
exports.updateLatestExecutedState = updateLatestExecutedState;