"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepInstallMlModel = stepInstallMlModel;
var _ml_model = require("../../../elasticsearch/ml_model");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepInstallMlModel(context) {
  var _context$esReferences;
  const {
    logger,
    packageInstallContext,
    esClient,
    savedObjectsClient
  } = context;
  let esReferences = (_context$esReferences = context.esReferences) !== null && _context$esReferences !== void 0 ? _context$esReferences : [];
  esReferences = await (0, _utils.withPackageSpan)('Install ML models', () => (0, _ml_model.installMlModel)(packageInstallContext, esClient, savedObjectsClient, logger, esReferences));
  return {
    esReferences
  };
}