"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepInstallKibanaAssets = stepInstallKibanaAssets;
var _install = require("../../../kibana/assets/install");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepInstallKibanaAssets(context) {
  const {
    savedObjectsClient,
    savedObjectsImporter,
    savedObjectTagAssignmentService,
    savedObjectTagClient,
    logger,
    installedPkg,
    packageInstallContext,
    spaceId
  } = context;
  const {
    packageInfo
  } = packageInstallContext;
  const {
    name: pkgName,
    title: pkgTitle
  } = packageInfo;
  const kibanaAssetPromise = (0, _utils.withPackageSpan)('Install Kibana assets', () => (0, _install.installKibanaAssetsAndReferences)({
    savedObjectsClient,
    savedObjectsImporter,
    savedObjectTagAssignmentService,
    savedObjectTagClient,
    pkgName,
    pkgTitle,
    packageInstallContext,
    installedPkg,
    logger,
    spaceId,
    assetTags: packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.asset_tags
  }));
  // Necessary to avoid async promise rejection warning
  // See https://stackoverflow.com/questions/40920179/should-i-refrain-from-handling-promise-rejection-asynchronously
  kibanaAssetPromise.catch(() => {});
  return {
    kibanaAssetPromise
  };
}