"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTemplateInputs = getTemplateInputs;
exports.templatePackagePolicyToFullInputStreams = void 0;
var _lodash = require("lodash");
var _jsYaml = require("js-yaml");
var _package_to_package_policy = require("../../../../common/services/package_to_package_policy");
var _package_policy = require("../../package_policy");
var _app_context = require("../../app_context");
var _full_agent_policy_to_yaml = require("../../../../common/services/full_agent_policy_to_yaml");
var _package_policies_to_agent_inputs = require("../../agent_policies/package_policies_to_agent_inputs");
var _ = require(".");
var _get = require("./get");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Function based off storedPackagePolicyToAgentInputs, it only creates the `streams` section instead of the FullAgentPolicyInput
const templatePackagePolicyToFullInputStreams = packagePolicyInputs => {
  const fullInputsStreams = [];
  if (!packagePolicyInputs || packagePolicyInputs.length === 0) return fullInputsStreams;
  packagePolicyInputs.forEach(input => {
    const fullInputStream = {
      // @ts-ignore-next-line the following id is actually one level above the one in fullInputStream, but the linter thinks it gets overwritten
      id: input.policy_template ? `${input.type}-${input.policy_template}` : `${input.type}`,
      type: input.type,
      ...(0, _package_policies_to_agent_inputs.getFullInputStreams)(input, true)
    };

    // deeply merge the input.config values with the full policy input stream
    (0, _lodash.merge)(fullInputStream, Object.entries(input.config || {}).reduce((acc, [key, {
      value
    }]) => {
      acc[key] = value;
      return acc;
    }, {}));
    fullInputsStreams.push(fullInputStream);
  });
  return fullInputsStreams;
};
exports.templatePackagePolicyToFullInputStreams = templatePackagePolicyToFullInputStreams;
async function getTemplateInputs(soClient, pkgName, pkgVersion, format, prerelease) {
  const packageInfoMap = new Map();
  let packageInfo;
  if (packageInfoMap.has(pkgName)) {
    packageInfo = packageInfoMap.get(pkgName);
  } else {
    packageInfo = await (0, _.getPackageInfo)({
      savedObjectsClient: soClient,
      pkgName,
      pkgVersion,
      prerelease
    });
  }
  const emptyPackagePolicy = (0, _package_to_package_policy.packageToPackagePolicy)(packageInfo, '');
  const inputsWithStreamIds = (0, _package_policy.getInputsWithStreamIds)(emptyPackagePolicy, undefined, true);
  const assetsMap = await (0, _get.getPackageAssetsMap)({
    logger: _app_context.appContextService.getLogger(),
    packageInfo,
    savedObjectsClient: soClient
  });
  const compiledInputs = await (0, _package_policy._compilePackagePolicyInputs)(packageInfo, emptyPackagePolicy.vars || {}, inputsWithStreamIds, assetsMap);
  const packagePolicyWithInputs = {
    ...emptyPackagePolicy,
    inputs: compiledInputs
  };
  const inputs = templatePackagePolicyToFullInputStreams(packagePolicyWithInputs.inputs);
  if (format === 'json') {
    return {
      inputs
    };
  } else if (format === 'yml') {
    const yaml = (0, _jsYaml.safeDump)({
      inputs
    }, {
      skipInvalid: true,
      sortKeys: _full_agent_policy_to_yaml._sortYamlKeys
    });
    return yaml;
  }
  return {
    inputs: []
  };
}