"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBulkAssets = getBulkAssets;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getBulkAssets(soClient, assetIds) {
  const {
    resolved_objects: resolvedObjects
  } = await soClient.bulkResolve(assetIds);
  const res = resolvedObjects.map(({
    saved_object: savedObject
  }) => savedObject).filter(savedObject => {
    var _savedObject$error;
    return (savedObject === null || savedObject === void 0 ? void 0 : (_savedObject$error = savedObject.error) === null || _savedObject$error === void 0 ? void 0 : _savedObject$error.statusCode) !== 404 && _constants.allowedAssetTypesLookup.has(savedObject.type);
  }).map(obj => {
    var _obj$attributes, _obj$attributes2;
    return {
      id: obj.id,
      type: obj.type,
      updatedAt: obj.updated_at,
      attributes: {
        title: (_obj$attributes = obj.attributes) === null || _obj$attributes === void 0 ? void 0 : _obj$attributes.title,
        description: (_obj$attributes2 = obj.attributes) === null || _obj$attributes2 === void 0 ? void 0 : _obj$attributes2.description
      }
    };
  });
  return res;
}