"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAssets = void 0;
var _registry = require("../../../registry");
var _dataset = require("./dataset");
var _ingest_pipeline = require("./dataset/ingest_pipeline");
var _manifest = require("./manifest");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Mimic the use of an archive buffer via the same naming conventions
const createAssets = assetOptions => {
  const {
    name,
    version,
    datasets
  } = assetOptions;
  return [{
    path: `${(0, _registry.pkgToPkgKey)({
      name,
      version
    })}/manifest.yml`,
    content: Buffer.from((0, _manifest.createManifest)(assetOptions))
  }, ...datasets.map(datasetConfiguration => {
    const {
      name: datasetName,
      type: datasetType
    } = datasetConfiguration;
    return [{
      path: `${(0, _registry.pkgToPkgKey)({
        name,
        version
      })}/data_stream/${datasetName}/manifest.yml`,
      content: Buffer.from((0, _dataset.createDatasetManifest)(datasetName, assetOptions))
    },
    // NOTE: buildDefaultSettings() will add a reference to the global ILM policy when
    // building the index template based on the fields assets.
    {
      path: `${(0, _registry.pkgToPkgKey)({
        name,
        version
      })}/data_stream/${datasetName}/fields/base-fields.yml`,
      content: Buffer.from((0, _dataset.createBaseFields)())
    }, {
      path: `${(0, _registry.pkgToPkgKey)({
        name,
        version
      })}/data_stream/${datasetName}/elasticsearch/ingest_pipeline/default.yml`,
      content: Buffer.from((0, _ingest_pipeline.createDefaultPipeline)(datasetName, datasetType))
    }];
  }).flat()];
};
exports.createAssets = createAssets;