"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateCspPackagePolicyToV8110 = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migrateCspPackagePolicyToV8110 = packagePolicyDoc => {
  var _packagePolicyDoc$att;
  if (((_packagePolicyDoc$att = packagePolicyDoc.attributes.package) === null || _packagePolicyDoc$att === void 0 ? void 0 : _packagePolicyDoc$att.name) !== 'cloud_security_posture') {
    return {
      attributes: packagePolicyDoc.attributes
    };
  }
  const updatedAttributes = packagePolicyDoc.attributes;
  const gcpPackage = updatedAttributes.inputs.find(input => input.type === 'cloudbeat/cis_gcp');
  if (gcpPackage) {
    var _gcpPackage$streams$, _gcpPackage$streams$$;
    const isGcpAccountTypeExists = (_gcpPackage$streams$ = gcpPackage.streams[0]) === null || _gcpPackage$streams$ === void 0 ? void 0 : (_gcpPackage$streams$$ = _gcpPackage$streams$.vars) === null || _gcpPackage$streams$$ === void 0 ? void 0 : _gcpPackage$streams$$.hasOwnProperty('gcp.account_type');
    if (!isGcpAccountTypeExists) {
      const migratedPolicy = {
        'gcp.account_type': {
          value: 'single-account',
          type: 'text'
        }
      };
      gcpPackage.streams[0].vars = {
        ...(gcpPackage.streams[0].vars || {}),
        ...migratedPolicy
      };
    }
  }
  return {
    attributes: updatedAttributes
  };
};
exports.migrateCspPackagePolicyToV8110 = migrateCspPackagePolicyToV8110;