"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAPIRoutes = void 0;
var _constants = require("../../../common/constants");
var _security = require("../../services/security");
var _constants2 = require("../../constants");
var _types = require("../../types");
var AgentService = _interopRequireWildcard(require("../../services/agents"));
var _agent = require("../../types/rest_spec/agent");
var _security2 = require("../../services/security/security");
var _handlers = require("./handlers");
var _actions_handlers = require("./actions_handlers");
var _unenroll_handler = require("./unenroll_handler");
var _upgrade_handler = require("./upgrade_handler");
var _request_diagnostics_handler = require("./request_diagnostics_handler");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerAPIRoutes = (router, config) => {
  // Get one
  router.versioned.get({
    path: _constants2.AGENT_API_ROUTES.INFO_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetOneAgentRequestSchema
    }
  }, _handlers.getAgentHandler);

  // Update
  router.versioned.put({
    path: _constants2.AGENT_API_ROUTES.UPDATE_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.UpdateAgentRequestSchema
    }
  }, _handlers.updateAgentHandler);

  // Bulk Update Tags
  router.versioned.post({
    path: _constants2.AGENT_API_ROUTES.BULK_UPDATE_AGENT_TAGS_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _agent.PostBulkUpdateAgentTagsRequestSchema
    }
  }, _handlers.bulkUpdateAgentTagsHandler);

  // Delete
  router.versioned.delete({
    path: _constants2.AGENT_API_ROUTES.DELETE_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.DeleteAgentRequestSchema
    }
  }, _handlers.deleteAgentHandler);

  // List
  router.versioned.get({
    path: _constants2.AGENT_API_ROUTES.LIST_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetAgentsRequestSchema
    }
  }, _handlers.getAgentsHandler);

  // List Agent Tags
  router.versioned.get({
    path: _constants2.AGENT_API_ROUTES.LIST_TAGS_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetTagsRequestSchema
    }
  }, _handlers.getAgentTagsHandler);

  // Agent actions
  router.versioned.post({
    path: _constants2.AGENT_API_ROUTES.ACTIONS_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostNewAgentActionRequestSchema
    }
  }, (0, _actions_handlers.postNewAgentActionHandlerBuilder)({
    getAgent: AgentService.getAgentById,
    cancelAgentAction: AgentService.cancelAgentAction,
    createAgentAction: AgentService.createAgentAction,
    getAgentActions: AgentService.getAgentActions
  }));
  router.versioned.post({
    path: _constants2.AGENT_API_ROUTES.CANCEL_ACTIONS_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostCancelActionRequestSchema
    }
  }, (0, _actions_handlers.postCancelActionHandlerBuilder)({
    getAgent: AgentService.getAgentById,
    cancelAgentAction: AgentService.cancelAgentAction,
    createAgentAction: AgentService.createAgentAction,
    getAgentActions: AgentService.getAgentActions
  }));

  // Get agents by Action_Ids
  router.versioned.post({
    path: _constants2.AGENT_API_ROUTES.LIST_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostRetrieveAgentsByActionsRequestSchema
    }
  }, _handlers.postRetrieveAgentsByActionsHandler);
  router.versioned.post({
    path: _constants2.AGENT_API_ROUTES.UNENROLL_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostAgentUnenrollRequestSchema
    }
  }, _unenroll_handler.postAgentUnenrollHandler);

  // mark as deprecated
  router.versioned.put({
    path: _constants2.AGENT_API_ROUTES.REASSIGN_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PutAgentReassignRequestSchemaDeprecated
    }
  }, _handlers.putAgentsReassignHandlerDeprecated);
  router.versioned.post({
    path: _constants2.AGENT_API_ROUTES.REASSIGN_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostAgentReassignRequestSchema
    }
  }, _handlers.postAgentsReassignHandler);
  router.versioned.post({
    path: _constants2.AGENT_API_ROUTES.REQUEST_DIAGNOSTICS_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostRequestDiagnosticsActionRequestSchema
    }
  }, _request_diagnostics_handler.requestDiagnosticsHandler);
  router.versioned.post({
    path: _constants2.AGENT_API_ROUTES.BULK_REQUEST_DIAGNOSTICS_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostBulkRequestDiagnosticsActionRequestSchema
    }
  }, _request_diagnostics_handler.bulkRequestDiagnosticsHandler);
  router.versioned.get({
    path: _constants2.AGENT_API_ROUTES.LIST_UPLOADS_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.ListAgentUploadsRequestSchema
    }
  }, _handlers.getAgentUploadsHandler);
  router.versioned.get({
    path: _constants2.AGENT_API_ROUTES.GET_UPLOAD_FILE_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetAgentUploadFileRequestSchema
    }
  }, _handlers.getAgentUploadFileHandler);

  // Get agent status for policy
  router.versioned.get({
    path: _constants2.AGENT_API_ROUTES.STATUS_PATTERN,
    fleetAuthz: fleetAuthz => (0, _security2.calculateRouteAuthz)(fleetAuthz, (0, _security.getRouteRequiredAuthz)('get', _constants2.AGENT_API_ROUTES.STATUS_PATTERN)).granted
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetAgentStatusRequestSchema
    }
  }, _handlers.getAgentStatusForAgentPolicyHandler);
  router.versioned.get({
    path: _constants2.AGENT_API_ROUTES.STATUS_PATTERN_DEPRECATED,
    fleetAuthz: {
      fleet: {
        readAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetAgentStatusRequestSchema
    }
  }, _handlers.getAgentStatusForAgentPolicyHandler);
  // Agent data
  router.versioned.get({
    path: _constants2.AGENT_API_ROUTES.DATA_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetAgentDataRequestSchema
    }
  }, _handlers.getAgentDataHandler);

  // upgrade agent
  router.versioned.post({
    path: _constants2.AGENT_API_ROUTES.UPGRADE_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostAgentUpgradeRequestSchema
    }
  }, _upgrade_handler.postAgentUpgradeHandler);
  // bulk upgrade
  router.versioned.post({
    path: _constants2.AGENT_API_ROUTES.BULK_UPGRADE_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostBulkAgentUpgradeRequestSchema
    }
  }, _upgrade_handler.postBulkAgentsUpgradeHandler);

  // Current actions
  router.versioned.get({
    path: _constants2.AGENT_API_ROUTES.ACTION_STATUS_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetActionStatusRequestSchema
    }
  }, _handlers.getActionStatusHandler);

  // Bulk reassign
  router.versioned.post({
    path: _constants2.AGENT_API_ROUTES.BULK_REASSIGN_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostBulkAgentReassignRequestSchema
    }
  }, _handlers.postBulkAgentReassignHandler);

  // Bulk unenroll
  router.versioned.post({
    path: _constants2.AGENT_API_ROUTES.BULK_UNENROLL_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostBulkAgentUnenrollRequestSchema
    }
  }, _unenroll_handler.postBulkAgentsUnenrollHandler);

  // Available versions for upgrades
  router.versioned.get({
    path: _constants2.AGENT_API_ROUTES.AVAILABLE_VERSIONS_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgents: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: false
  }, _handlers.getAvailableVersionsHandler);
};
exports.registerAPIRoutes = registerAPIRoutes;