"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Wrapper = exports.WithoutHeaderLayout = exports.Page = exports.ContentWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Wrapper = exports.Wrapper = _styledComponents.default.div`
  background-color: ${props => props.theme.eui.euiColorEmptyShade};

  // Set the min height to the viewport size minus the height of any global Kibana headers
  min-height: calc(100vh - var(--euiFixedHeadersOffset, 0));
`;
const Page = exports.Page = (0, _styledComponents.default)(_eui.EuiPage)`
  background: ${props => props.theme.eui.euiColorEmptyShade};
  width: 100%;
  align-self: center;
  margin: auto;
  flex: 1;
`;
const ContentWrapper = exports.ContentWrapper = _styledComponents.default.div`
  height: 100%;
  padding-left: ${props => props.theme.eui.euiSizeM};
  padding-right: ${props => props.theme.eui.euiSizeM};
`;
const WithoutHeaderLayout = ({
  restrictWidth,
  children
}) => /*#__PURE__*/_react.default.createElement(Wrapper, null, /*#__PURE__*/_react.default.createElement(Page, {
  restrictWidth: restrictWidth || 1200
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(ContentWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), children))));
exports.WithoutHeaderLayout = WithoutHeaderLayout;