"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetFleetStatusQuery = exports.sendSetup = exports.sendPostFleetSetup = exports.sendGetFleetStatus = void 0;
var _reactQuery = require("@tanstack/react-query");
var _services = require("../../services");
var _constants = require("../../../common/constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sendSetup = () => {
  return (0, _use_request.sendRequest)({
    path: _services.setupRouteService.getSetupPath(),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendSetup = sendSetup;
const sendGetFleetStatus = () => {
  return (0, _use_request.sendRequest)({
    path: _services.fleetSetupRouteService.getFleetSetupPath(),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendGetFleetStatus = sendGetFleetStatus;
const useGetFleetStatusQuery = () => {
  return (0, _reactQuery.useQuery)(['fleetStatus'], () => (0, _use_request.sendRequestForRq)({
    path: _services.fleetSetupRouteService.getFleetSetupPath(),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  }));
};
exports.useGetFleetStatusQuery = useGetFleetStatusQuery;
const sendPostFleetSetup = ({
  forceRecreate
}) => {
  return (0, _use_request.sendRequest)({
    method: 'post',
    path: _services.fleetSetupRouteService.postFleetSetupPath(),
    version: _constants.API_VERSIONS.public.v1,
    body: {
      forceRecreate
    }
  });
};
exports.sendPostFleetSetup = sendPostFleetSetup;