"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendDeleteFleetServerHost = sendDeleteFleetServerHost;
exports.sendPostFleetServerHost = sendPostFleetServerHost;
exports.sendPutFleetServerHost = sendPutFleetServerHost;
exports.useGetFleetServerHosts = useGetFleetServerHosts;
var _services = require("../../../common/services");
var _constants = require("../../../common/constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetFleetServerHosts() {
  return (0, _use_request.useRequest)({
    method: 'get',
    path: _services.fleetServerHostsRoutesService.getListPath(),
    version: _constants.API_VERSIONS.public.v1
  });
}
function sendDeleteFleetServerHost(itemId) {
  return (0, _use_request.sendRequest)({
    method: 'delete',
    path: _services.fleetServerHostsRoutesService.getDeletePath(itemId),
    version: _constants.API_VERSIONS.public.v1
  });
}
function sendPutFleetServerHost(itemId, body) {
  return (0, _use_request.sendRequest)({
    method: 'put',
    path: _services.fleetServerHostsRoutesService.getUpdatePath(itemId),
    version: _constants.API_VERSIONS.public.v1,
    body
  });
}
function sendPostFleetServerHost(body) {
  return (0, _use_request.sendRequest)({
    method: 'post',
    path: _services.fleetServerHostsRoutesService.getCreatePath(),
    version: _constants.API_VERSIONS.public.v1,
    body
  });
}