"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFleetServerHostsForPolicy = useFleetServerHostsForPolicy;
var _react = require("react");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Return Fleet server hosts urls and proxy for a given agent policy
 */
function useFleetServerHostsForPolicy(agentPolicy) {
  const fleetServerHostsRequest = (0, _use_request.useGetFleetServerHosts)();
  const fleetProxiesRequest = (0, _use_request.useGetFleetProxies)();
  const downloadSourceRequest = (0, _use_request.useGetDownloadSources)();
  const allFleetServerHosts = (0, _react.useMemo)(() => {
    var _fleetServerHostsRequ, _fleetServerHostsRequ2;
    return (_fleetServerHostsRequ = (_fleetServerHostsRequ2 = fleetServerHostsRequest.data) === null || _fleetServerHostsRequ2 === void 0 ? void 0 : _fleetServerHostsRequ2.items) !== null && _fleetServerHostsRequ !== void 0 ? _fleetServerHostsRequ : [];
  }, [fleetServerHostsRequest]);
  const allFleetProxies = (0, _react.useMemo)(() => {
    var _fleetProxiesRequest$, _fleetProxiesRequest$2;
    return (_fleetProxiesRequest$ = (_fleetProxiesRequest$2 = fleetProxiesRequest.data) === null || _fleetProxiesRequest$2 === void 0 ? void 0 : _fleetProxiesRequest$2.items) !== null && _fleetProxiesRequest$ !== void 0 ? _fleetProxiesRequest$ : [];
  }, [fleetProxiesRequest]);
  const allDownloadSource = (0, _react.useMemo)(() => {
    var _downloadSourceReques, _downloadSourceReques2;
    return (_downloadSourceReques = (_downloadSourceReques2 = downloadSourceRequest.data) === null || _downloadSourceReques2 === void 0 ? void 0 : _downloadSourceReques2.items) !== null && _downloadSourceReques !== void 0 ? _downloadSourceReques : [];
  }, [downloadSourceRequest]);
  const [fleetServerHosts, fleetProxy, downloadSource] = (0, _react.useMemo)(() => {
    var _fleetServerHost$host;
    const fleetServerHost = allFleetServerHosts.find(item => agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.fleet_server_host_id ? item.id === (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.fleet_server_host_id) : item.is_default);
    const fleetServerHostProxy = fleetServerHost !== null && fleetServerHost !== void 0 && fleetServerHost.proxy_id ? allFleetProxies.find(proxy => proxy.id === fleetServerHost.proxy_id) : undefined;
    const currentDownloadSource = agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.download_source_id ? allDownloadSource.find(d => d.id === (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.download_source_id)) : allDownloadSource.find(d => d.is_default);
    return [(_fleetServerHost$host = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : fleetServerHost.host_urls) !== null && _fleetServerHost$host !== void 0 ? _fleetServerHost$host : [], fleetServerHostProxy, currentDownloadSource];
  }, [agentPolicy, allFleetProxies, allFleetServerHosts, allDownloadSource]);
  const isLoadingInitialRequest = fleetServerHostsRequest.isLoading && fleetServerHostsRequest.isInitialRequest || fleetProxiesRequest.isLoading && fleetProxiesRequest.isInitialRequest || downloadSourceRequest.isLoading && downloadSourceRequest.isInitialRequest;
  return (0, _react.useMemo)(() => ({
    isLoadingInitialRequest,
    fleetServerHosts,
    fleetProxy,
    downloadSource,
    allFleetServerHosts
  }), [fleetServerHosts, fleetProxy, downloadSource, allFleetServerHosts, isLoadingInitialRequest]);
}