"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendGetAllFleetServerAgents = sendGetAllFleetServerAgents;
var _constants = require("../constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function sendGetAllFleetServerAgents(onlyCount = false) {
  var _packagePoliciesRes$d, _packagePoliciesRes$d2, _response$data, _response$data$total, _response$data2;
  const packagePoliciesRes = await (0, _use_request.sendGetPackagePolicies)({
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT,
    kuery: `${_constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:${_constants.FLEET_SERVER_PACKAGE}`
  });
  const agentPolicyIds = [...new Set((_packagePoliciesRes$d = packagePoliciesRes === null || packagePoliciesRes === void 0 ? void 0 : (_packagePoliciesRes$d2 = packagePoliciesRes.data) === null || _packagePoliciesRes$d2 === void 0 ? void 0 : _packagePoliciesRes$d2.items.map(p => p.policy_id)) !== null && _packagePoliciesRes$d !== void 0 ? _packagePoliciesRes$d : [])];
  if (agentPolicyIds.length === 0) {
    return {
      allFleetServerAgents: []
    };
  }
  const kuery = `${_constants.AGENTS_PREFIX}.policy_id:(${agentPolicyIds.map(id => `"${id}"`).join(' or ')})`;
  const response = await (0, _use_request.sendGetAgents)({
    kuery,
    perPage: onlyCount ? 0 : _constants.SO_SEARCH_LIMIT,
    showInactive: false
  });
  return {
    allFleetServerAgents: ((_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.items) || [],
    fleetServerAgentsCount: (_response$data$total = (_response$data2 = response.data) === null || _response$data2 === void 0 ? void 0 : _response$data2.total) !== null && _response$data$total !== void 0 ? _response$data$total : 0
  };
}