"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyActionsMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../hooks");
var _agent_enrollment_flyout = require("./agent_enrollment_flyout");
var _context_menu_actions = require("./context_menu_actions");
var _danger_eui_context_menu_item = require("./danger_eui_context_menu_item");
var _package_policy_delete_provider = require("./package_policy_delete_provider");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PackagePolicyActionsMenu = ({
  agentPolicy,
  packagePolicy,
  showAddAgent,
  upgradePackagePolicyHref,
  defaultIsOpen = false,
  from
}) => {
  var _packagePolicy$packag, _packagePolicy$packag2;
  const [isEnrollmentFlyoutOpen, setIsEnrollmentFlyoutOpen] = (0, _react.useState)(false);
  const {
    getHref
  } = (0, _hooks.useLink)();
  const canWriteIntegrationPolicies = (0, _hooks.useAuthz)().integrations.writeIntegrationPolicies;
  const canAddAgents = (0, _hooks.useAuthz)().fleet.addAgents;
  const refreshAgentPolicy = (0, _hooks.useAgentPolicyRefresh)();
  const [isActionsMenuOpen, setIsActionsMenuOpen] = (0, _react.useState)(defaultIsOpen);
  const isManaged = Boolean(packagePolicy.is_managed);
  const agentPolicyIsManaged = Boolean(agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.is_managed);
  const isAddAgentVisible = showAddAgent && agentPolicy && !agentPolicyIsManaged;
  const onEnrollmentFlyoutClose = (0, _react.useMemo)(() => {
    return () => setIsEnrollmentFlyoutOpen(false);
  }, []);
  const menuItems = [
  // FIXME: implement View package policy action
  // <EuiContextMenuItem
  //   disabled
  //   icon="inspect"
  //   onClick={() => {}}
  //   key="packagePolicyView"
  // >
  //   <FormattedMessage
  //     id="xpack.fleet.policyDetails.packagePoliciesTable.viewActionTitle"
  //     defaultMessage="View integration"
  //   />
  // </EuiContextMenuItem>,
  ...(isAddAgentVisible ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "PackagePolicyActionsAddAgentItem",
    icon: "plusInCircle",
    onClick: () => {
      setIsActionsMenuOpen(false);
      setIsEnrollmentFlyoutOpen(true);
    },
    key: "addAgent",
    disabled: !canAddAgents
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.integrationList.addAgent",
    defaultMessage: "Add agent"
  }))] : []), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "PackagePolicyActionsEditItem",
    disabled: !canWriteIntegrationPolicies || !agentPolicy,
    icon: "pencil",
    href: `${getHref('integration_policy_edit', {
      packagePolicyId: packagePolicy.id
    })}${from ? `?from=${from}` : ''}`,
    key: "packagePolicyEdit"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.packagePoliciesTable.editActionTitle",
    defaultMessage: "Edit integration"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "PackagePolicyActionsUpgradeItem",
    disabled: !packagePolicy.hasUpgrade || !canWriteIntegrationPolicies || !upgradePackagePolicyHref,
    icon: "refresh",
    href: upgradePackagePolicyHref,
    key: "packagePolicyUpgrade"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.packagePoliciesTable.upgradeActionTitle",
    defaultMessage: "Upgrade integration policy"
  }))
  // FIXME: implement Copy package policy action
  // <EuiContextMenuItem disabled icon="copy" onClick={() => {}} key="packagePolicyCopy">
  //   <FormattedMessage
  //     id="xpack.fleet.policyDetails.packagePoliciesTable.copyActionTitle"
  //     defaultMessage="Copy integration"
  //   />
  // </EuiContextMenuItem>,
  ];
  if (!agentPolicy || !agentPolicyIsManaged) {
    const ContextMenuItem = canWriteIntegrationPolicies ? _danger_eui_context_menu_item.DangerEuiContextMenuItem : _eui.EuiContextMenuItem;
    menuItems.push( /*#__PURE__*/_react.default.createElement(_package_policy_delete_provider.PackagePolicyDeleteProvider, {
      agentPolicy: agentPolicy,
      key: "packagePolicyDelete"
    }, deletePackagePoliciesPrompt => {
      return /*#__PURE__*/_react.default.createElement(ContextMenuItem, {
        "data-test-subj": "PackagePolicyActionsDeleteItem",
        disabled: !canWriteIntegrationPolicies,
        icon: "trash",
        onClick: () => {
          deletePackagePoliciesPrompt([packagePolicy.id], () => {
            setIsActionsMenuOpen(false);
            refreshAgentPolicy();
          });
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyDetails.packagePoliciesTable.deleteActionTitle",
        defaultMessage: "Delete integration"
      }));
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEnrollmentFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_agent_enrollment_flyout.AgentEnrollmentFlyout, {
    agentPolicy: agentPolicy,
    onClose: onEnrollmentFlyoutClose,
    isIntegrationFlow: true,
    installedPackagePolicy: {
      name: (packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name) || '',
      version: (packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.version) || ''
    }
  })), /*#__PURE__*/_react.default.createElement(_context_menu_actions.ContextMenuActions, {
    isManaged: isManaged,
    isOpen: isActionsMenuOpen,
    items: menuItems,
    onChange: open => setIsActionsMenuOpen(open)
  }));
};
exports.PackagePolicyActionsMenu = PackagePolicyActionsMenu;