"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureStandaloneAgentStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigureStandaloneAgentStep = ({
  isK8s,
  selectedPolicyId,
  yaml,
  downloadLink,
  isComplete,
  onCopy
}) => {
  const core = (0, _hooks.useStartServices)();
  const {
    docLinks
  } = core;
  const policyMsg = isK8s === 'IS_KUBERNETES' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.stepConfigureAgentDescriptionk8s",
    defaultMessage: "Copy or download the Kubernetes manifest inside the Kubernetes cluster. Update {ESUsernameVariable} and {ESPasswordVariable} environment variables in the Daemonset to match your Elasticsearch credentials. Note that the following manifest contains resource limits that may not be appropriate for a production environment, review our guide on {scalingGuideLink} before deploying this manifest.",
    values: {
      ESUsernameVariable: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "ES_USERNAME"),
      ESPasswordVariable: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "ES_PASSWORD"),
      scalingGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: docLinks.links.fleet.scalingKubernetesResourcesAndLimits,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.fleet.agentEnrollment.k8ScalingGuideLinkText",
        defaultMessage: "Scaling Elastic Agent on Kubernetes"
      }))
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.stepConfigureAgentDescription",
    defaultMessage: "Copy this policy to the {fileName} on the host where the Elastic Agent is installed. Modify {ESUsernameVariable} and {ESPasswordVariable} in the {outputSection} section of {fileName} to use your Elasticsearch credentials.",
    values: {
      fileName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "elastic-agent.yml"),
      ESUsernameVariable: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "ES_USERNAME"),
      ESPasswordVariable: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "ES_PASSWORD"),
      outputSection: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "outputs")
    }
  });
  const downloadMsg = isK8s === 'IS_KUBERNETES' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.downloadPolicyButtonk8s",
    defaultMessage: "Download Manifest"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.downloadPolicyButton",
    defaultMessage: "Download Policy"
  });
  return {
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepConfigureAgentTitle', {
      defaultMessage: 'Configure the agent'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !yaml ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, policyMsg), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: yaml
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => {
        copy();
        if (onCopy) onCopy();
      },
      iconType: "copyClipboard"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentEnrollment.copyPolicyButton",
      defaultMessage: "Copy to clipboard"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "download",
      href: downloadLink,
      onClick: () => {
        if (onCopy) onCopy();
      },
      isDisabled: !downloadLink
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, downloadMsg)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "yaml",
      style: {
        maxHeight: 300
      },
      fontSize: "m",
      "data-test-subj": "agentPolicyCodeBlock"
    }, yaml))),
    status: !yaml ? 'loading' : isComplete ? 'complete' : undefined
  };
};
exports.ConfigureStandaloneAgentStep = ConfigureStandaloneAgentStep;