"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputFormKafkaTopics = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OutputFormKafkaTopics = ({
  inputs
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "m",
    hasShadow: false,
    paddingSize: 'm',
    color: 'subdued',
    "data-test-subj": "settingsOutputsFlyout.kafkaTopicsPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "FleetEditOutputFlyoutKafkaHeaders"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.kafkaTopcisTitle",
    defaultMessage: "Topics"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaTopicsDefaultTopicLabel",
      defaultMessage: "Default topic"
    })
  }, inputs.kafkaDefaultTopicInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "settingsOutputsFlyout.kafkaDefaultTopicInput",
    fullWidth: true
  }, inputs.kafkaDefaultTopicInput.props))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.OutputFormKafkaTopics = OutputFormKafkaTopics;