"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputFormKafkaSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../../../hooks");
var _constants = require("../../../../../../../common/constants");
var _multi_row_input = require("../multi_row_input");
var _output_form_kafka_topics = require("./output_form_kafka_topics");
var _output_form_kafka_headers = require("./output_form_kafka_headers");
var _output_form_kafka_broker = require("./output_form_kafka_broker");
var _output_form_kafka_compression = require("./output_form_kafka_compression");
var _output_form_kafka_partitioning = require("./output_form_kafka_partitioning");
var _output_form_kafka_authentication = require("./output_form_kafka_authentication");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OutputFormKafkaSection = props => {
  const {
    inputs,
    useSecretsStorage,
    onToggleSecretStorage
  } = props;
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const kafkaVersionOptions = (0, _react.useMemo)(() => _constants.kafkaSupportedVersions.map(version => ({
    text: version,
    label: version
  })), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaVersionInputLabel",
      defaultMessage: "Kafka version"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "settingsOutputsFlyout.kafkaVersionInput"
  }, inputs.kafkaVersionInput.props, {
    options: kafkaVersionOptions,
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.kafkaVersionInputPlaceholder', {
      defaultMessage: 'Specify version'
    })
  }))), /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.kafkaHostsInputPlaceholder', {
      defaultMessage: 'Specify host'
    }),
    sortable: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaHostsInputDescription",
      defaultMessage: "Specify the URLs that your agents will use to connect to Kafka. {guideLink}.",
      values: {
        guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.kafkaSettings,
          target: "_blank",
          external: true
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.kafkaUserGuideLink",
          defaultMessage: "Learn more"
        }))
      }
    }),
    label: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.kafkaHostsInputLabel', {
      defaultMessage: 'Hosts'
    })
  }, inputs.kafkaHostsInput.props)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_output_form_kafka_authentication.OutputFormKafkaAuthentication, {
    inputs: inputs,
    useSecretsStorage: useSecretsStorage,
    onToggleSecretStorage: onToggleSecretStorage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_output_form_kafka_partitioning.OutputFormKafkaPartitioning, {
    inputs: inputs
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_output_form_kafka_topics.OutputFormKafkaTopics, {
    inputs: inputs
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_output_form_kafka_headers.OutputFormKafkaHeaders, {
    inputs: inputs
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_output_form_kafka_compression.OutputFormKafkaCompression, {
    inputs: inputs
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_output_form_kafka_broker.OutputFormKafkaBroker, {
    inputs: inputs
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaKeyInputLabel",
      defaultMessage: "Key (optional)"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaKeyInputHelpText",
      defaultMessage: "If configured, the event key can be extracted from the event using a format string."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "settingsOutputsFlyout.kafkaKeyInput",
    fullWidth: true
  }, inputs.kafkaKeyInput.props))));
};
exports.OutputFormKafkaSection = OutputFormKafkaSection;