"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HealthCheckPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactQuery = require("@tanstack/react-query");
var _hooks = require("../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POLLING_INTERVAL_S = 10; // 10 sec
const POLLING_INTERVAL_MS = POLLING_INTERVAL_S * 1000;
const HealthCheckPanel = () => {
  var _healthData$data, _healthData$data2, _healthData$data3, _healthData$error$mes, _healthData$error, _healthData$error2;
  const [selectedFleetServerHost, setSelectedFleetServerHost] = (0, _react.useState)();
  const {
    data
  } = (0, _hooks.useGetFleetServerHosts)();
  const fleetServerHosts = (0, _react.useMemo)(() => {
    var _data$items;
    return (_data$items = data === null || data === void 0 ? void 0 : data.items) !== null && _data$items !== void 0 ? _data$items : [];
  }, [data === null || data === void 0 ? void 0 : data.items]);
  (0, _react.useEffect)(() => {
    const defaultHost = fleetServerHosts.find(item => item.is_default === true);
    if (defaultHost) {
      setSelectedFleetServerHost(defaultHost);
    }
  }, [fleetServerHosts]);
  const hostName = (0, _react.useMemo)(() => (selectedFleetServerHost === null || selectedFleetServerHost === void 0 ? void 0 : selectedFleetServerHost.host_urls[0]) || '', [selectedFleetServerHost === null || selectedFleetServerHost === void 0 ? void 0 : selectedFleetServerHost.host_urls]);
  const [healthData, setHealthData] = (0, _react.useState)();
  const {
    data: healthCheckResponse
  } = (0, _reactQuery.useQuery)(['fleetServerHealth', hostName], () => (0, _hooks.sendPostHealthCheck)({
    host: hostName
  }), {
    refetchInterval: POLLING_INTERVAL_MS
  });
  (0, _react.useEffect)(() => {
    setHealthData(healthCheckResponse);
  }, [healthCheckResponse]);
  const fleetServerHostsOptions = (0, _react.useMemo)(() => [...fleetServerHosts.map(fleetServerHost => {
    return {
      inputDisplay: `${fleetServerHost.name} (${fleetServerHost.host_urls[0]})`,
      value: fleetServerHost.id
    };
  })], [fleetServerHosts]);
  const healthStatus = statusValue => {
    if (!statusValue) return null;
    let color;
    switch (statusValue) {
      case 'HEALTHY':
        color = 'success';
        break;
      case 'UNHEALTHY':
        color = 'warning';
        break;
      case 'OFFLINE':
        color = 'subdued';
        break;
      default:
        color = 'subdued';
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: color
    }, statusValue);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.healthCheckPanel.description",
    defaultMessage: "Select the host used to enroll Fleet Server. The connection is refreshed every {interval}s.",
    values: {
      interval: POLLING_INTERVAL_S
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: `
            min-width: 600px;
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    "data-test-subj": "fleetDebug.fleetServerHostsSelect",
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "relative",
      color: ''
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.debug.healthCheckPanel.fleetServerHostsLabel",
      defaultMessage: "Fleet Server Hosts"
    })),
    onChange: fleetServerHostId => {
      setHealthData(undefined);
      setSelectedFleetServerHost(fleetServerHosts.find(fleetServerHost => fleetServerHost.id === fleetServerHostId));
    },
    valueOfSelected: selectedFleetServerHost === null || selectedFleetServerHost === void 0 ? void 0 : selectedFleetServerHost.id,
    options: fleetServerHostsOptions
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, healthData !== null && healthData !== void 0 && (_healthData$data = healthData.data) !== null && _healthData$data !== void 0 && _healthData$data.status && hostName === (healthData === null || healthData === void 0 ? void 0 : (_healthData$data2 = healthData.data) === null || _healthData$data2 === void 0 ? void 0 : _healthData$data2.host) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.healthCheckPanel.status",
    defaultMessage: "Status:"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, healthStatus(healthData === null || healthData === void 0 ? void 0 : (_healthData$data3 = healthData.data) === null || _healthData$data3 === void 0 ? void 0 : _healthData$data3.status))) : null)), (healthData === null || healthData === void 0 ? void 0 : healthData.error) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Error",
    color: "danger"
  }, (_healthData$error$mes = healthData === null || healthData === void 0 ? void 0 : (_healthData$error = healthData.error) === null || _healthData$error === void 0 ? void 0 : _healthData$error.message) !== null && _healthData$error$mes !== void 0 ? _healthData$error$mes : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.healthCheckPanel.fetchError",
    defaultMessage: "Message: {errorMessage}",
    values: {
      errorMessage: healthData === null || healthData === void 0 ? void 0 : (_healthData$error2 = healthData.error) === null || _healthData$error2 === void 0 ? void 0 : _healthData$error2.message
    }
  }))));
};
exports.HealthCheckPanel = HealthCheckPanel;