"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInactiveAgentsCalloutHasBeenDismissed = void 0;
var _react = require("react");
var _constants = require("../../../../../../constants");
var _hooks = require("../../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInactiveAgentsCalloutHasBeenDismissed = () => {
  const {
    uiSettings,
    storage
  } = (0, _hooks.useStartServices)();
  const [inactiveAgentsCalloutHasBeenDismissed, setInactiveAgentsCalloutHasBeenDismissed] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    var _storage$get;
    setInactiveAgentsCalloutHasBeenDismissed(uiSettings.get('hideAnnouncements', false) || ((_storage$get = storage.get(_constants.TOUR_STORAGE_KEYS.INACTIVE_AGENTS)) === null || _storage$get === void 0 ? void 0 : _storage$get.active) === false);
  }, [storage, uiSettings]);
  const updateInactiveAgentsCalloutHasBeenDismissed = newValue => {
    storage.set(_constants.TOUR_STORAGE_KEYS.INACTIVE_AGENTS, {
      active: false
    });
    setInactiveAgentsCalloutHasBeenDismissed(newValue);
  };
  return [inactiveAgentsCalloutHasBeenDismissed, updateInactiveAgentsCalloutHasBeenDismissed];
};
exports.useInactiveAgentsCalloutHasBeenDismissed = useInactiveAgentsCalloutHasBeenDismissed;