"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardsButtons = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../../common/constants");
var _hooks = require("../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDashboardExists = dashboardId => {
  const [dashboardExists, setDashboardExists] = _react.default.useState(false);
  const [loading, setLoading] = _react.default.useState(true);
  const {
    dashboard: dashboardPlugin
  } = (0, _hooks.useStartServices)();
  (0, _react.useEffect)(() => {
    const fetchDashboard = async () => {
      try {
        const findDashboardsService = await dashboardPlugin.findDashboardsService();
        const [dashboard] = await findDashboardsService.findByIds([dashboardId]);
        setLoading(false);
        setDashboardExists((dashboard === null || dashboard === void 0 ? void 0 : dashboard.status) === 'success');
      } catch (e) {
        setLoading(false);
        setDashboardExists(false);
      }
    };
    fetchDashboard();
  }, [dashboardId, dashboardPlugin]);
  return {
    dashboardExists,
    loading
  };
};
const DashboardsButtons = () => {
  const dashboardLocator = (0, _hooks.useDashboardLocator)();
  const getDashboardHref = dashboardId => {
    return (dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
      dashboardId
    })) || '';
  };
  const {
    dashboardExists,
    loading: dashboardLoading
  } = useDashboardExists(_constants.DASHBOARD_LOCATORS_IDS.ELASTIC_AGENT_OVERVIEW);
  if (dashboardLoading || !dashboardExists) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "dashboardApp",
    href: getDashboardHref(_constants.DASHBOARD_LOCATORS_IDS.ELASTIC_AGENT_OVERVIEW),
    "data-test-subj": "ingestOverviewLinkButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.ingestOverviewlinkButton",
    defaultMessage: "Ingest Overview Metrics"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "dashboardApp",
    href: getDashboardHref(_constants.DASHBOARD_LOCATORS_IDS.ELASTIC_AGENT_AGENT_INFO),
    "data-test-subj": "agentInfoLinkButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.agentInfoLinkButton",
    defaultMessage: "Agent Info Metrics"
  })))));
};
exports.DashboardsButtons = DashboardsButtons;