"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentlessPolicy = void 0;
exports.useSetupTechnology = useSetupTechnology;
var _react = require("react");
var _services = require("../../../../../services");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _components = require("../../components");
var _constants = require("../../../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentlessPolicy = () => {
  const {
    agentless: agentlessExperimentalFeatureEnabled
  } = _services.ExperimentalFeaturesService.get();
  const {
    cloud
  } = (0, _hooks.useStartServices)();
  const isServerless = !!(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled);
  const isAgentlessEnabled = agentlessExperimentalFeatureEnabled && isServerless;
  const isAgentlessPolicyId = id => isAgentlessEnabled && id === _constants.AGENTLESS_POLICY_ID;
  return {
    isAgentlessEnabled,
    isAgentlessPolicyId
  };
};
exports.useAgentlessPolicy = useAgentlessPolicy;
function useSetupTechnology({
  updateNewAgentPolicy,
  newAgentPolicy,
  updateAgentPolicy,
  setSelectedPolicyTab
}) {
  const {
    isAgentlessEnabled
  } = useAgentlessPolicy();
  const [selectedSetupTechnology, setSelectedSetupTechnology] = (0, _react.useState)(_types.SetupTechnology.AGENT_BASED);
  const [agentlessPolicy, setAgentlessPolicy] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const fetchAgentlessPolicy = async () => {
      const {
        data,
        error
      } = await (0, _hooks.sendGetOneAgentPolicy)(_constants.AGENTLESS_POLICY_ID);
      const isAgentlessAvailable = !error && data && data.item;
      if (isAgentlessAvailable) {
        setAgentlessPolicy(data.item);
      }
    };
    if (isAgentlessEnabled) {
      fetchAgentlessPolicy();
    }
  }, [isAgentlessEnabled]);
  const handleSetupTechnologyChange = (0, _react.useCallback)(setupTechnology => {
    if (!isAgentlessEnabled || setupTechnology === selectedSetupTechnology) {
      return;
    }
    if (setupTechnology === _types.SetupTechnology.AGENTLESS) {
      if (agentlessPolicy) {
        updateAgentPolicy(agentlessPolicy);
        setSelectedPolicyTab(_components.SelectedPolicyTab.EXISTING);
      }
    } else if (setupTechnology === _types.SetupTechnology.AGENT_BASED) {
      updateNewAgentPolicy(newAgentPolicy);
      setSelectedPolicyTab(_components.SelectedPolicyTab.NEW);
    }
    setSelectedSetupTechnology(setupTechnology);
  }, [isAgentlessEnabled, selectedSetupTechnology, agentlessPolicy, updateAgentPolicy, setSelectedPolicyTab, updateNewAgentPolicy, newAgentPolicy]);
  return {
    handleSetupTechnologyChange,
    agentlessPolicy,
    selectedSetupTechnology
  };
}