"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepSelectHosts = exports.SelectedPolicyTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../../../../../hooks");
var _components = require("../../../components");
var _constants = require("../../../../../constants");
var _services = require("../../../../../services");
var _step_select_agent_policy = require("./step_select_agent_policy");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let SelectedPolicyTab = exports.SelectedPolicyTab = /*#__PURE__*/function (SelectedPolicyTab) {
  SelectedPolicyTab["NEW"] = "new";
  SelectedPolicyTab["EXISTING"] = "existing";
  return SelectedPolicyTab;
}({});
const StyledEuiTabbedContent = (0, _styledComponents.default)(_eui.EuiTabbedContent)`
  [role='tabpanel'] {
    padding-top: ${props => props.theme.eui.euiSizeM};
  }
`;
const StepSelectHosts = ({
  agentPolicy,
  updateAgentPolicy,
  newAgentPolicy,
  updateNewAgentPolicy,
  withSysMonitoring,
  updateSysMonitoring,
  validation,
  packageInfo,
  setHasAgentPolicyError,
  updateSelectedTab,
  selectedAgentPolicyId
}) => {
  let agentPolicies = [];
  const {
    data: agentPoliciesData,
    error: err
  } = (0, _hooks.useGetAgentPolicies)({
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT,
    sortField: 'name',
    sortOrder: 'asc',
    full: false,
    // package_policies will always be empty
    noAgentCount: true // agentPolicy.agents will always be 0
  });
  if (err) {
    // eslint-disable-next-line no-console
    console.debug('Could not retrieve agent policies');
  }
  agentPolicies = (0, _react.useMemo)(() => (agentPoliciesData === null || agentPoliciesData === void 0 ? void 0 : agentPoliciesData.items.filter(policy => !policy.is_managed)) || [], [agentPoliciesData === null || agentPoliciesData === void 0 ? void 0 : agentPoliciesData.items]);
  (0, _react.useEffect)(() => {
    if (agentPolicies.length > 0) {
      updateNewAgentPolicy({
        ...newAgentPolicy,
        name: (0, _services.incrementPolicyName)(agentPolicies)
      });
    }
  }, [agentPolicies.length]); // eslint-disable-line react-hooks/exhaustive-deps

  const tabs = [{
    id: SelectedPolicyTab.NEW,
    'data-test-subj': 'newHostsTab',
    name: 'New hosts',
    content: /*#__PURE__*/_react.default.createElement(_components.AgentPolicyIntegrationForm, {
      agentPolicy: newAgentPolicy,
      updateAgentPolicy: updateNewAgentPolicy,
      withSysMonitoring: withSysMonitoring,
      updateSysMonitoring: updateSysMonitoring,
      validation: validation
    })
  }, {
    id: SelectedPolicyTab.EXISTING,
    'data-test-subj': 'existingHostsTab',
    name: 'Existing hosts',
    content: /*#__PURE__*/_react.default.createElement(_step_select_agent_policy.StepSelectAgentPolicy, {
      packageInfo: packageInfo,
      agentPolicy: agentPolicy,
      updateAgentPolicy: updateAgentPolicy,
      setHasAgentPolicyError: setHasAgentPolicyError,
      selectedAgentPolicyId: selectedAgentPolicyId
    })
  }];
  const handleOnTabClick = tab => updateSelectedTab(tab.id);
  return agentPolicies.length > 0 ? /*#__PURE__*/_react.default.createElement(StyledEuiTabbedContent, {
    initialSelectedTab: selectedAgentPolicyId ? tabs[1] : tabs[0],
    tabs: tabs,
    onTabClick: handleOnTabClick
  }) : /*#__PURE__*/_react.default.createElement(_components.AgentPolicyIntegrationForm, {
    agentPolicy: newAgentPolicy,
    updateAgentPolicy: updateNewAgentPolicy,
    withSysMonitoring: withSysMonitoring,
    updateSysMonitoring: updateSysMonitoring,
    validation: validation
  });
};
exports.StepSelectHosts = StepSelectHosts;