"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepSelectAgentPolicy = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _components = require("../../../../../components");
var _services = require("../../../../../services");
var _hooks = require("../../../../../hooks");
var _constants = require("../../../../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyFormRow = (0, _styledComponents.default)(_eui.EuiFormRow)`
  .euiFormRow__label {
    width: 100%;
  }
`;
function useAgentPoliciesOptions(packageInfo) {
  // Fetch agent policies info
  const {
    data: agentPoliciesData,
    error: agentPoliciesError,
    isLoading: isAgentPoliciesLoading
  } = (0, _hooks.useGetAgentPolicies)({
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT,
    sortField: 'name',
    sortOrder: 'asc',
    noAgentCount: true,
    // agentPolicy.agents will always be 0
    full: false // package_policies will always be empty
  });
  const agentPolicies = (0, _react.useMemo)(() => (agentPoliciesData === null || agentPoliciesData === void 0 ? void 0 : agentPoliciesData.items.filter(policy => !policy.is_managed)) || [], [agentPoliciesData === null || agentPoliciesData === void 0 ? void 0 : agentPoliciesData.items]);
  const {
    data: outputsData,
    isLoading: isOutputLoading
  } = (0, _hooks.useGetOutputs)();

  // get all package policies with apm integration or the current integration
  const {
    data: packagePoliciesForThisPackage,
    isLoading: isLoadingPackagePolicies
  } = (0, _hooks.useGetPackagePolicies)({
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT,
    kuery: `${_constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name: ${packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name}`
  });
  const packagePoliciesForThisPackageByAgentPolicyId = (0, _react.useMemo)(() => packagePoliciesForThisPackage === null || packagePoliciesForThisPackage === void 0 ? void 0 : packagePoliciesForThisPackage.items.reduce((acc, packagePolicy) => {
    acc[packagePolicy.policy_id] = true;
    return acc;
  }, {}), [packagePoliciesForThisPackage === null || packagePoliciesForThisPackage === void 0 ? void 0 : packagePoliciesForThisPackage.items]);
  const {
    getDataOutputForPolicy
  } = (0, _react.useMemo)(() => {
    var _outputsData$items, _outputsData$items2;
    const defaultOutput = ((_outputsData$items = outputsData === null || outputsData === void 0 ? void 0 : outputsData.items) !== null && _outputsData$items !== void 0 ? _outputsData$items : []).find(output => output.is_default);
    const outputsById = ((_outputsData$items2 = outputsData === null || outputsData === void 0 ? void 0 : outputsData.items) !== null && _outputsData$items2 !== void 0 ? _outputsData$items2 : []).reduce((acc, output) => {
      acc[output.id] = output;
      return acc;
    }, {});
    return {
      getDataOutputForPolicy: policy => {
        return policy.data_output_id ? outputsById[policy.data_output_id] : defaultOutput;
      }
    };
  }, [outputsData]);
  const agentPolicyOptions = (0, _react.useMemo)(() => packageInfo ? agentPolicies.map(policy => {
    var _getDataOutputForPoli;
    const isLimitedPackageAlreadyInPolicy = (0, _services.isPackageLimited)(packageInfo) && (packagePoliciesForThisPackageByAgentPolicyId === null || packagePoliciesForThisPackageByAgentPolicyId === void 0 ? void 0 : packagePoliciesForThisPackageByAgentPolicyId[policy.id]);
    const isAPMPackageAndDataOutputIsLogstash = (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name) === _constants.FLEET_APM_PACKAGE && ((_getDataOutputForPoli = getDataOutputForPolicy(policy)) === null || _getDataOutputForPoli === void 0 ? void 0 : _getDataOutputForPoli.type) === _constants.outputType.Logstash;
    return {
      inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, policy.name), isAPMPackageAndDataOutputIsLogstash && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyDisabledAPMLogstashOuputText",
        defaultMessage: "Logstash output for agent integration is not supported with APM"
      })))),
      value: policy.id,
      disabled: isLimitedPackageAlreadyInPolicy || isAPMPackageAndDataOutputIsLogstash,
      'data-test-subj': 'agentPolicyItem'
    };
  }) : [], [packageInfo, agentPolicies, packagePoliciesForThisPackageByAgentPolicyId, getDataOutputForPolicy]);
  return {
    agentPoliciesError,
    isLoading: isOutputLoading || isAgentPoliciesLoading || isLoadingPackagePolicies,
    agentPolicyOptions,
    agentPolicies
  };
}
function doesAgentPolicyHaveLimitedPackage(policy, pkgInfo) {
  return policy ? (0, _services.isPackageLimited)(pkgInfo) && (0, _services.doesAgentPolicyAlreadyIncludePackage)(policy, pkgInfo.name) : false;
}
const StepSelectAgentPolicy = ({
  packageInfo,
  agentPolicy,
  updateAgentPolicy: updateSelectedAgentPolicy,
  setHasAgentPolicyError,
  selectedAgentPolicyId
}) => {
  var _agentPolicy$id, _selectedAgentPolicy$;
  const {
    isReady: isFleetReady
  } = (0, _hooks.useFleetStatus)();
  const [selectedAgentPolicyError, setSelectedAgentPolicyError] = (0, _react.useState)();
  const {
    isLoading,
    agentPoliciesError,
    agentPolicyOptions,
    agentPolicies
  } = useAgentPoliciesOptions(packageInfo);
  // Selected agent policy state
  const [selectedPolicyId, setSelectedPolicyId] = (0, _react.useState)((_agentPolicy$id = agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id) !== null && _agentPolicy$id !== void 0 ? _agentPolicy$id : selectedAgentPolicyId || (agentPolicies.length === 1 ? agentPolicies[0].id : undefined));
  const [isLoadingSelectedAgentPolicy, setIsLoadingSelectedAgentPolicy] = (0, _react.useState)(false);
  const [selectedAgentPolicy, setSelectedAgentPolicy] = (0, _react.useState)(agentPolicy);
  const updateAgentPolicy = (0, _react.useCallback)(selectedPolicy => {
    setSelectedAgentPolicy(selectedPolicy);
    updateSelectedAgentPolicy(selectedPolicy);
  }, [updateSelectedAgentPolicy]);
  // Update parent selected agent policy state
  (0, _react.useEffect)(() => {
    const fetchAgentPolicyInfo = async () => {
      if (selectedPolicyId) {
        setIsLoadingSelectedAgentPolicy(true);
        const {
          data,
          error
        } = await (0, _hooks.sendGetOneAgentPolicy)(selectedPolicyId);
        if (error) {
          setSelectedAgentPolicyError(error);
          updateAgentPolicy(undefined);
        } else if (data && data.item) {
          setSelectedAgentPolicyError(undefined);
          updateAgentPolicy(data.item);
        }
        setIsLoadingSelectedAgentPolicy(false);
      } else {
        setSelectedAgentPolicyError(undefined);
        updateAgentPolicy(undefined);
      }
    };
    if (!agentPolicy || selectedPolicyId !== agentPolicy.id) {
      fetchAgentPolicyInfo();
    }
  }, [selectedPolicyId, agentPolicy, updateAgentPolicy]);

  // Try to select default agent policy
  (0, _react.useEffect)(() => {
    if (!selectedPolicyId && agentPolicies.length && agentPolicyOptions.length) {
      const enabledOptions = agentPolicyOptions.filter(option => !option.disabled);
      if (enabledOptions.length === 1) {
        setSelectedPolicyId(enabledOptions[0].value);
      }
    }
  }, [agentPolicies, agentPolicyOptions, selectedPolicyId]);

  // Bubble up any issues with agent policy selection
  (0, _react.useEffect)(() => {
    if (selectedPolicyId && !selectedAgentPolicyError) {
      setHasAgentPolicyError(false);
    } else setHasAgentPolicyError(true);
  }, [selectedAgentPolicyError, selectedPolicyId, setHasAgentPolicyError]);
  const onChange = (0, _react.useCallback)(newValue => setSelectedPolicyId(newValue === '' ? undefined : newValue), []);

  // Display agent policies list error if there is one
  if (agentPoliciesError) {
    return /*#__PURE__*/_react.default.createElement(_components.Error, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.errorLoadingAgentPoliciesTitle",
        defaultMessage: "Error loading agent policies"
      }),
      error: agentPoliciesError
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyFormGroupTitle",
      defaultMessage: "Agent policy"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyFormGroupDescription",
      defaultMessage: "Agent policies are used to manage a group of integrations across a set of agents."
    })))
  }, /*#__PURE__*/_react.default.createElement(AgentPolicyFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyLabel",
      defaultMessage: "Agent policy"
    }))),
    helpText: isFleetReady && selectedPolicyId && !isLoadingSelectedAgentPolicy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyAgentsDescriptionText",
      defaultMessage: "{count, plural, one {# agent is} other {# agents are}} enrolled with the selected agent policy.",
      values: {
        count: (_selectedAgentPolicy$ = selectedAgentPolicy === null || selectedAgentPolicy === void 0 ? void 0 : selectedAgentPolicy.agents) !== null && _selectedAgentPolicy$ !== void 0 ? _selectedAgentPolicy$ : 0
      }
    }) : null,
    isInvalid: Boolean(!selectedPolicyId || !packageInfo || selectedAgentPolicy && doesAgentPolicyHaveLimitedPackage(selectedAgentPolicy, packageInfo)),
    error: !selectedPolicyId ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.noPolicySelectedError",
      defaultMessage: "An agent policy is required."
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.cannotAddLimitedIntegrationError",
      defaultMessage: "This integration can only be added once per agent policy."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    placeholder: _i18n.i18n.translate('xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyPlaceholderText', {
      defaultMessage: 'Select an agent policy to add this integration to'
    }),
    fullWidth: true,
    isLoading: isLoading || !packageInfo || isLoadingSelectedAgentPolicy,
    options: agentPolicyOptions,
    valueOfSelected: selectedPolicyId,
    onChange: onChange,
    "data-test-subj": "agentPolicySelect",
    "aria-label": "Select Agent Policy"
  })))), selectedAgentPolicyError ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_components.Error, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.errorLoadingSelectedAgentPolicyTitle",
      defaultMessage: "Error loading selected agent policy"
    }),
    error: selectedAgentPolicyError
  })) : null));
};
exports.StepSelectAgentPolicy = StepSelectAgentPolicy;