"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldShowStreamsByDefault = exports.PackagePolicyInputPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _services = require("../../../services");
var _package_policy_input_config = require("./package_policy_input_config");
var _package_policy_input_stream = require("./package_policy_input_stream");
var _hooks = require("./hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ShortenedHorizontalRule = (0, _styledComponents.default)(_eui.EuiHorizontalRule)`
  &&& {
    width: ${11 / 12 * 100}%;
    margin-left: auto;
  }
`;
const shouldShowStreamsByDefault = (packageInput, packageInputStreams, packagePolicyInput, defaultDataStreamId) => {
  if (!packagePolicyInput.enabled) {
    return false;
  }
  return (0, _services.hasInvalidButRequiredVar)(packageInput.vars, packagePolicyInput.vars) || packageInputStreams.some(stream => {
    var _packagePolicyInput$s;
    return stream.enabled && (0, _services.hasInvalidButRequiredVar)(stream.vars, (_packagePolicyInput$s = packagePolicyInput.streams.find(pkgStream => stream.data_stream.dataset === pkgStream.data_stream.dataset)) === null || _packagePolicyInput$s === void 0 ? void 0 : _packagePolicyInput$s.vars);
  }) || packagePolicyInput.streams.some(stream => {
    return defaultDataStreamId && stream.id && stream.id === defaultDataStreamId;
  });
};
exports.shouldShowStreamsByDefault = shouldShowStreamsByDefault;
const PackagePolicyInputPanel = exports.PackagePolicyInputPanel = /*#__PURE__*/(0, _react.memo)(({
  packageInput,
  packageInfo,
  packageInputStreams,
  packagePolicyInput,
  packagePolicy,
  updatePackagePolicy,
  updatePackagePolicyInput,
  inputValidationResults,
  forceShowErrors,
  isEditPage = false
}) => {
  const defaultDataStreamId = (0, _hooks.useDataStreamId)();
  // Showing streams toggle state
  const [isShowingStreams, setIsShowingStreams] = (0, _react.useState)(() => shouldShowStreamsByDefault(packageInput, packageInputStreams, packagePolicyInput, defaultDataStreamId));

  // Errors state
  const errorCount = inputValidationResults && (0, _services.countValidationErrors)(inputValidationResults);
  const hasErrors = forceShowErrors && errorCount;
  const hasInputStreams = (0, _react.useMemo)(() => packageInputStreams.length > 0, [packageInputStreams.length]);
  const inputStreams = (0, _react.useMemo)(() => packageInputStreams.map(packageInputStream => {
    return {
      packageInputStream,
      packagePolicyInputStream: packagePolicyInput.streams.find(stream => stream.data_stream.dataset === packageInputStream.data_stream.dataset)
    };
  }).filter(stream => Boolean(stream.packagePolicyInputStream)), [packageInputStreams, packagePolicyInput.streams]);
  const titleElementId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", {
      id: titleElementId
    }, packageInput.title || packageInput.type)))),
    checked: packagePolicyInput.enabled,
    disabled: packagePolicyInput.keep_enabled,
    onChange: e => {
      const enabled = e.target.checked;
      updatePackagePolicyInput({
        enabled,
        streams: packagePolicyInput.streams.map(stream => ({
          ...stream,
          enabled
        }))
      });
      if (!enabled && isShowingStreams) {
        setIsShowingStreams(false);
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, hasErrors ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.errorCountText",
    defaultMessage: "{count, plural, one {# error} other {# errors}}",
    values: {
      count: errorCount
    }
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: hasErrors ? 'danger' : 'primary',
    onClick: () => setIsShowingStreams(!isShowingStreams),
    iconType: isShowingStreams ? 'arrowUp' : 'arrowDown',
    iconSide: "right",
    "aria-expanded": isShowingStreams,
    "aria-labelledby": titleElementId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.expandLabel",
    defaultMessage: "Change defaults"
  })))))), isShowingStreams ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }) : null, isShowingStreams && packageInput.vars && packageInput.vars.length ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_package_policy_input_config.PackagePolicyInputConfig, {
    hasInputStreams: hasInputStreams,
    packageInputVars: packageInput.vars,
    packagePolicyInput: packagePolicyInput,
    updatePackagePolicyInput: updatePackagePolicyInput,
    inputVarsValidationResults: {
      vars: inputValidationResults === null || inputValidationResults === void 0 ? void 0 : inputValidationResults.vars
    },
    forceShowErrors: forceShowErrors,
    isEditPage: isEditPage
  }), hasInputStreams ? /*#__PURE__*/_react.default.createElement(ShortenedHorizontalRule, {
    margin: "m"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })) : null, isShowingStreams ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, inputStreams.map(({
    packageInputStream,
    packagePolicyInputStream
  }, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_package_policy_input_stream.PackagePolicyInputStreamConfig, {
    packageInfo: packageInfo,
    packagePolicy: packagePolicy,
    packageInputStream: packageInputStream,
    packagePolicyInputStream: packagePolicyInputStream,
    updatePackagePolicy: updatePackagePolicy,
    updatePackagePolicyInputStream: updatedStream => {
      const indexOfUpdatedStream = packagePolicyInput.streams.findIndex(stream => stream.data_stream.dataset === packageInputStream.data_stream.dataset);
      const newStreams = [...packagePolicyInput.streams];
      newStreams[indexOfUpdatedStream] = {
        ...newStreams[indexOfUpdatedStream],
        ...updatedStream
      };
      const updatedInput = {
        streams: newStreams
      };

      // Update input enabled state if needed
      if (!packagePolicyInput.enabled && updatedStream.enabled) {
        updatedInput.enabled = true;
      } else if (packagePolicyInput.enabled && !newStreams.find(stream => stream.enabled)) {
        updatedInput.enabled = false;
      }
      updatePackagePolicyInput(updatedInput);
    },
    inputStreamValidationResults: inputValidationResults === null || inputValidationResults === void 0 ? void 0 : inputValidationResults.streams[packagePolicyInputStream.data_stream.dataset],
    forceShowErrors: forceShowErrors,
    isEditPage: isEditPage
  }), index !== inputStreams.length - 1 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(ShortenedHorizontalRule, {
    margin: "none"
  })) : null))) : null);
});