"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyCreateInlineForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
var _generate_new_agent_policy = require("../../../../../../common/services/generate_new_agent_policy");
var _ = require(".");
var _agent_policy_advanced_fields = require("./agent_policy_advanced_fields");
var _agent_policy_system_monitoring_field = require("./agent_policy_system_monitoring_field");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  .ingest-active-button {
    color: ${props => props.theme.eui.euiColorPrimary};
  }
`;
const AgentPolicyCreateInlineForm = ({
  updateAgentPolicy,
  isFleetServerPolicy,
  agentPolicyName
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const [touchedFields, setTouchedFields] = (0, _react.useState)({});
  const [withSysMonitoring, setWithSysMonitoring] = (0, _react.useState)(true);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [newAgentPolicy, setNewAgentPolicy] = (0, _react.useState)((0, _generate_new_agent_policy.generateNewAgentPolicyWithDefaults)({
    name: agentPolicyName,
    has_fleet_server: isFleetServerPolicy
  }));
  const updateNewAgentPolicy = (0, _react.useCallback)(updatedFields => {
    setNewAgentPolicy({
      ...newAgentPolicy,
      ...updatedFields
    });
  }, [setNewAgentPolicy, newAgentPolicy]);
  const validation = (0, _.agentPolicyFormValidation)(newAgentPolicy);
  const createAgentPolicy = (0, _react.useCallback)(async () => {
    try {
      setIsLoading(true);
      const resp = await (0, _hooks.sendCreateAgentPolicy)(newAgentPolicy, {
        withSysMonitoring
      });
      if (resp.error) throw resp.error;
      if (resp.data) {
        updateAgentPolicy(resp.data.item);
      }
    } catch (e) {
      updateAgentPolicy(null, mapError(e));
    } finally {
      setIsLoading(false);
    }
  }, [newAgentPolicy, withSysMonitoring, updateAgentPolicy]);
  function mapError(e) {
    switch (e.statusCode) {
      case 409:
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyCreation.errorMessage",
          defaultMessage: "An agent policy already exists with this name."
        });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, isFleetServerPolicy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyForm.createAgentPolicyFleetServer",
    defaultMessage: "Fleet Server runs on Elastic Agent, and agents are enrolled in agent policies which represent hosts. We'll need to create a dedicated agent policy for Fleet Server to run on dedicated hosts."
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyForm.createAgentPolicyTypeOfHosts",
    defaultMessage: "Settings for the monitored host are configured in the {agentPolicy}. Create a new agent policy to get started.",
    values: {
      agentPolicy: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.agentPolicy,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.createAgentPolicyDocLink",
        defaultMessage: "agent policy"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    key: "name",
    error: touchedFields.name && validation.name ? validation.name : null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: newAgentPolicy.name,
    disabled: isLoading,
    onChange: e => updateNewAgentPolicy({
      name: e.target.value
    }),
    isInvalid: Boolean(touchedFields.name && validation.name),
    onBlur: () => setTouchedFields({
      ...touchedFields,
      name: true
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.nameFieldPlaceholder', {
      defaultMessage: 'Choose a name'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    disabled: !newAgentPolicy.name,
    onClick: () => createAgentPolicy(),
    isLoading: isLoading,
    "data-test-subj": isFleetServerPolicy ? 'createFleetServerPolicyBtn' : 'createPolicyBtn'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyForm.createAgentPolicyText",
    defaultMessage: "Create policy"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_agent_policy_system_monitoring_field.AgentPolicyFormSystemMonitoringCheckbox, {
    withSysMonitoring: withSysMonitoring,
    updateSysMonitoring: value => setWithSysMonitoring(value)
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    id: "advancedOptionsJustChanged",
    "data-test-subj": "advancedOptionsButton",
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.advancedOptionsToggleLabel",
      defaultMessage: "Advanced options"
    }),
    buttonClassName: "ingest-active-button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_agent_policy_advanced_fields.AgentPolicyAdvancedOptionsContent, {
    agentPolicy: newAgentPolicy,
    updateAgentPolicy: updateNewAgentPolicy,
    validation: validation
  }))));
};
exports.AgentPolicyCreateInlineForm = AgentPolicyCreateInlineForm;