"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithPermissionsAndSetup = exports.FleetAppContext = exports.AppRoutes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _reactQuery = require("@tanstack/react-query");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _common = require("@kbn/kibana-react-plugin/common");
var _hooks = require("../integrations/hooks");
var _hooks2 = require("./hooks");
var _components = require("./components");
var _constants = require("./constants");
var _agent_policy = require("./sections/agent_policy");
var _data_stream = require("./sections/data_stream");
var _agents = require("./sections/agents");
var _create_package_policy_page = require("./sections/agent_policy/create_package_policy_page");
var _enrollment_token_list_page = require("./sections/agents/enrollment_token_list_page");
var _uninstall_token_list_page = require("./sections/agents/uninstall_token_list_page");
var _settings = require("./sections/settings");
var _debug = require("./sections/debug");
var _services = require("./services");
var _layouts = require("./layouts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FEEDBACK_URL = 'https://ela.st/fleet-feedback';
const queryClient = new _reactQuery.QueryClient();
const WithPermissionsAndSetup = exports.WithPermissionsAndSetup = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  (0, _hooks2.useBreadcrumbs)('base');
  const core = (0, _hooks2.useStartServices)();
  const {
    notifications
  } = core;
  const authz = (0, _hooks2.useAuthz)();
  const hasAnyFleetReadPrivileges = authz.fleet.readEnrollmentTokens || authz.fleet.readAgents || authz.fleet.readAgentPolicies || authz.fleet.readSettings;
  const [isPermissionsLoading, setIsPermissionsLoading] = (0, _react.useState)(false);
  const [permissionsError, setPermissionsError] = (0, _react.useState)();
  const [isInitialized, setIsInitialized] = (0, _react.useState)(false);
  const [initializationError, setInitializationError] = (0, _react.useState)(null);
  const isAddIntegrationsPath = !!(0, _reactRouterDom.useRouteMatch)(_constants.FLEET_ROUTING_PATHS.add_integration_to_policy);
  const isDebugPath = !!(0, _reactRouterDom.useRouteMatch)(_constants.FLEET_ROUTING_PATHS.debug);
  (0, _react.useEffect)(() => {
    (async () => {
      setIsPermissionsLoading(false);
      setPermissionsError(undefined);
      setIsInitialized(false);
      setInitializationError(null);
      try {
        var _permissionsResponse$;
        setIsPermissionsLoading(true);
        const permissionsResponse = await (0, _hooks2.sendGetPermissionsCheck)();
        setIsPermissionsLoading(false);
        if ((_permissionsResponse$ = permissionsResponse.data) !== null && _permissionsResponse$ !== void 0 && _permissionsResponse$.success) {
          try {
            var _setupResponse$data, _setupResponse$data$n;
            const setupResponse = await (0, _hooks2.sendSetup)();
            if (setupResponse.error) {
              setInitializationError(setupResponse.error);
            }
            if ((_setupResponse$data = setupResponse.data) !== null && _setupResponse$data !== void 0 && (_setupResponse$data$n = _setupResponse$data.nonFatalErrors) !== null && _setupResponse$data$n !== void 0 && _setupResponse$data$n.length) {
              notifications.toasts.addError(setupResponse.data.nonFatalErrors[0], {
                title: _i18n.i18n.translate('xpack.fleet.setup.uiPreconfigurationErrorTitle', {
                  defaultMessage: 'Configuration error'
                })
              });
            }
            if (!hasAnyFleetReadPrivileges) {
              setPermissionsError('MISSING_PRIVILEGES');
            }
          } catch (err) {
            setInitializationError(err);
          }
          setIsInitialized(true);
        } else {
          var _permissionsResponse$2;
          setPermissionsError(((_permissionsResponse$2 = permissionsResponse.data) === null || _permissionsResponse$2 === void 0 ? void 0 : _permissionsResponse$2.error) || 'REQUEST_ERROR');
        }
      } catch (err) {
        setPermissionsError('REQUEST_ERROR');
      }
    })();
  }, [notifications.toasts, hasAnyFleetReadPrivileges]);
  if (isPermissionsLoading || permissionsError) {
    return /*#__PURE__*/_react.default.createElement(_layouts.ErrorLayout, {
      isAddIntegrationsPath: isAddIntegrationsPath
    }, isPermissionsLoading ? /*#__PURE__*/_react.default.createElement(_components.Loading, null) : /*#__PURE__*/_react.default.createElement(_layouts.PermissionsError, {
      error: permissionsError
    }));
  }
  // Debug page moved outside of initialization to allow debugging when setup failed
  if (isDebugPath) {
    return /*#__PURE__*/_react.default.createElement(_debug.DebugPage, {
      setupError: initializationError,
      isInitialized: isInitialized
    });
  }
  if (!isInitialized || initializationError) {
    return /*#__PURE__*/_react.default.createElement(_layouts.ErrorLayout, {
      isAddIntegrationsPath: isAddIntegrationsPath
    }, initializationError ? /*#__PURE__*/_react.default.createElement(_components.Error, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.initializationErrorMessageTitle",
        defaultMessage: "Unable to initialize Fleet"
      }),
      error: initializationError
    }) : /*#__PURE__*/_react.default.createElement(_components.FleetSetupLoading, null));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
});

/**
 * Fleet Application context all the way down to the Router, but with no permissions or setup checks
 * and no routes defined
 */
const FleetAppContext = exports.FleetAppContext = /*#__PURE__*/(0, _react.memo)(({
  children,
  startServices,
  config,
  history,
  kibanaVersion,
  extensions,
  routerHistory,
  theme$,
  fleetStatus
}) => {
  const darkModeObservable = (0, _useObservable.default)(theme$);
  const isDarkMode = darkModeObservable && darkModeObservable.darkMode;
  return /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: startServices.application
    }
  }, /*#__PURE__*/_react.default.createElement(startServices.i18n.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...startServices,
      theme: {
        theme$
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_hooks2.ConfigContext.Provider, {
    value: config
  }, /*#__PURE__*/_react.default.createElement(_hooks2.KibanaVersionContext.Provider, {
    value: kibanaVersion
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: isDarkMode
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false
  }), /*#__PURE__*/_react.default.createElement(_hooks2.UIExtensionsContext.Provider, {
    value: extensions
  }, /*#__PURE__*/_react.default.createElement(_hooks2.FleetStatusProvider, {
    defaultFleetStatus: fleetStatus
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_hooks.PackageInstallProvider, {
    notifications: startServices.notifications,
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_hooks2.FlyoutContextProvider, null, children))))))))))))));
});
const FleetTopNav = /*#__PURE__*/(0, _react.memo)(({
  setHeaderActionMenu
}) => {
  const services = (0, _hooks2.useStartServices)();
  const {
    TopNavMenu
  } = services.navigation.ui;
  const topNavConfig = [{
    label: _i18n.i18n.translate('xpack.fleet.appNavigation.sendFeedbackButton', {
      defaultMessage: 'Send feedback'
    }),
    iconType: 'popout',
    run: () => window.open(FEEDBACK_URL)
  }];
  return /*#__PURE__*/_react.default.createElement(TopNavMenu, {
    appName: _i18n.i18n.translate('xpack.fleet.appTitle', {
      defaultMessage: 'Fleet'
    }),
    config: topNavConfig,
    setMenuMountPoint: setHeaderActionMenu
  });
});
const AppRoutes = exports.AppRoutes = /*#__PURE__*/(0, _react.memo)(({
  setHeaderActionMenu
}) => {
  var _fleetStatus$missingR;
  const flyoutContext = (0, _hooks2.useFlyoutContext)();
  const fleetStatus = (0, _hooks2.useFleetStatus)();
  const {
    agentTamperProtectionEnabled
  } = _services.ExperimentalFeaturesService.get();
  const authz = (0, _hooks2.useAuthz)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FleetTopNav, {
    setHeaderActionMenu: setHeaderActionMenu
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.agents
  }, authz.fleet.readAgents ? /*#__PURE__*/_react.default.createElement(_agents.AgentsApp, null) : /*#__PURE__*/_react.default.createElement(_layouts.ErrorLayout, {
    isAddIntegrationsPath: false
  }, /*#__PURE__*/_react.default.createElement(_layouts.PermissionsError, {
    error: "MISSING_PRIVILEGES",
    requiredFleetRole: "Agents Read"
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.policies
  }, authz.fleet.readAgentPolicies ? /*#__PURE__*/_react.default.createElement(_agent_policy.AgentPolicyApp, null) : /*#__PURE__*/_react.default.createElement(_layouts.ErrorLayout, {
    isAddIntegrationsPath: false
  }, /*#__PURE__*/_react.default.createElement(_layouts.PermissionsError, {
    error: "MISSING_PRIVILEGES",
    requiredFleetRole: "Agent policies Read"
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.enrollment_tokens
  }, authz.fleet.allAgents ? /*#__PURE__*/_react.default.createElement(_enrollment_token_list_page.EnrollmentTokenListPage, null) : /*#__PURE__*/_react.default.createElement(_layouts.ErrorLayout, {
    isAddIntegrationsPath: false
  }, /*#__PURE__*/_react.default.createElement(_layouts.PermissionsError, {
    error: "MISSING_PRIVILEGES",
    requiredFleetRole: "Agents All"
  }))), agentTamperProtectionEnabled && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.uninstall_tokens
  }, authz.fleet.allAgents ? /*#__PURE__*/_react.default.createElement(_uninstall_token_list_page.UninstallTokenListPage, null) : /*#__PURE__*/_react.default.createElement(_layouts.ErrorLayout, {
    isAddIntegrationsPath: false
  }, /*#__PURE__*/_react.default.createElement(_layouts.PermissionsError, {
    error: "MISSING_PRIVILEGES",
    requiredFleetRole: "Agents All"
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.data_streams
  }, /*#__PURE__*/_react.default.createElement(_data_stream.DataStreamApp, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings
  }, authz.fleet.readSettings ? /*#__PURE__*/_react.default.createElement(_settings.SettingsApp, null) : /*#__PURE__*/_react.default.createElement(_layouts.ErrorLayout, {
    isAddIntegrationsPath: false
  }, /*#__PURE__*/_react.default.createElement(_layouts.PermissionsError, {
    error: "MISSING_PRIVILEGES",
    requiredFleetRole: "Settings Read"
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.add_integration_to_policy
  }, /*#__PURE__*/_react.default.createElement(_create_package_policy_page.CreatePackagePolicyPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: ({
      location
    }) => {
      // BWC < 7.15 Fleet was using a hash router: redirect old routes using hash
      const shouldRedirectHash = location.pathname === '' && location.hash.length > 0;
      if (!shouldRedirectHash) {
        // Redirect to the first authorized tab
        const redirectTo = authz.fleet.readAgents ? _constants.FLEET_ROUTING_PATHS.agents : authz.fleet.readAgentPolicies ? _constants.FLEET_ROUTING_PATHS.policies : _constants.FLEET_ROUTING_PATHS.settings;
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: redirectTo
        });
      }
      const pathname = location.hash.replace(/^#(\/fleet)?/, '');
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: {
          ...location,
          pathname,
          hash: undefined
        }
      });
    }
  })), flyoutContext.isEnrollmentFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components.AgentEnrollmentFlyout, {
    defaultMode: fleetStatus.isReady && !((_fleetStatus$missingR = fleetStatus.missingRequirements) !== null && _fleetStatus$missingR !== void 0 && _fleetStatus$missingR.includes('fleet_server')) ? 'managed' : 'standalone',
    isIntegrationFlow: true,
    onClose: () => flyoutContext.closeEnrollmentFlyout()
  })), flyoutContext.isFleetServerFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components.FleetServerFlyout, {
    onClose: () => flyoutContext.closeFleetServerFlyout()
  })));
});