"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zodStringWithDurationValidation = exports.AGENT_POLICY_ADVANCED_SETTINGS = void 0;
var _i18n = require("@kbn/i18n");
var _zod = require("zod");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const zodStringWithDurationValidation = exports.zodStringWithDurationValidation = _zod.z.string().refine(val => val.match(/^(\d+[s|m|h|d])?$/), {
  message: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.downloadTimeoutValidationMessage', {
    defaultMessage: 'Must be a string with a time unit, e.g. 30s, 5m, 2h, 1d'
  })
});
const AGENT_POLICY_ADVANCED_SETTINGS = exports.AGENT_POLICY_ADVANCED_SETTINGS = [{
  name: 'agent.limits.go_max_procs',
  title: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.goMaxProcsTitle', {
    defaultMessage: 'GO_MAX_PROCS'
  }),
  description: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.goMaxProcsDescription', {
    defaultMessage: 'Limits the maximum number of CPUs that can be executing simultaneously'
  }),
  learnMoreLink: 'https://www.elastic.co/guide/en/fleet/current/enable-custom-policy-settings.html#limit-cpu-usage',
  api_field: {
    name: 'agent_limits_go_max_procs'
  },
  schema: _zod.z.number().int().min(0).default(0)
}, {
  name: 'agent.download.timeout',
  hidden: true,
  title: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.downloadTimeoutTitle', {
    defaultMessage: 'Agent binary download timeout'
  }),
  description: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.downloadTimeoutDescription', {
    defaultMessage: 'Timeout for downloading the agent binary'
  }),
  learnMoreLink: 'https://www.elastic.co/guide/en/fleet/current/enable-custom-policy-settings.html#configure-agent-download-timeout',
  api_field: {
    name: 'agent_download_timeout'
  },
  schema: zodStringWithDurationValidation.default('2h')
}, {
  name: 'agent.download.target_directory',
  hidden: true,
  api_field: {
    name: 'agent_download_target_directory'
  },
  title: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentDownloadTargetDirectoryTitle', {
    defaultMessage: 'Agent binary target directory'
  }),
  description: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentDownloadTargetDirectoryDescription', {
    defaultMessage: 'The disk path to which the agent binary will be downloaded'
  }),
  learnMoreLink: 'https://www.elastic.co/guide/en/fleet/current/elastic-agent-standalone-download.html',
  schema: _zod.z.string()
}, {
  name: 'agent.logging.metrics.period',
  hidden: true,
  api_field: {
    name: 'agent_logging_metrics_period'
  },
  title: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentLoggingMetricsPeriodTitle', {
    defaultMessage: 'Agent logging metrics period'
  }),
  description: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentLoggingMetricsPeriodDescription', {
    defaultMessage: 'The frequency of agent metrics logging'
  }),
  learnMoreLink: 'https://www.elastic.co/guide/en/fleet/current/elastic-agent-standalone-logging-config.html#elastic-agent-standalone-logging-settings',
  schema: zodStringWithDurationValidation.default('30s')
}, {
  name: 'agent.monitoring.http',
  hidden: true,
  api_field: {
    name: 'agent_monitoring_http'
  },
  title: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentMonitoringHttpTitle', {
    defaultMessage: 'Agent HTTP monitoring'
  }),
  description: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentMonitoringHttpDescription', {
    defaultMessage: 'Agent HTTP monitoring settings'
  }),
  learnMoreLink: 'https://www.elastic.co/guide/en/fleet/current/enable-custom-policy-settings.html#override-default-monitoring-port',
  schema: _zod.z.object({
    enabled: _zod.z.boolean().describe('Enabled').default(false),
    host: _zod.z.string().describe('Host').default('localhost'),
    port: _zod.z.number().describe('Port').min(0).max(65353).default(6791),
    'buffer.enabled': _zod.z.boolean().describe('Buffer Enabled').default(false)
  }).default({})
}, {
  name: 'agent.logging.level',
  hidden: true,
  title: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentLoggingLevelTitle', {
    defaultMessage: 'Agent Logging Level'
  }),
  description: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentLoggingLevelDescription', {
    defaultMessage: 'Sets the log level for all the agents on the policy. The default log level is "info"'
  }),
  api_field: {
    name: 'agent_logging_level'
  },
  schema: _zod.z.nativeEnum(_constants.agentLoggingLevels).default(_constants.agentLoggingLevels.Info)
}];